/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.publish.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class CloudEvent {
    public static final String SOURCE_URN_PREFIX = "urn:uuid:";
    public static final String SPEC_VERSION = "1.0";
    @JsonProperty(value="datacontenttype")
    private final String dataContentType = "application/json";
    @JsonProperty(value="specversion")
    private final String specVersion = "1.0";
    private final String source;
    private final String type;
    private final String id;
    private final JsonNode data;

    private CloudEvent(String providerId, String eventCode, String eventId, JsonNode data) {
        if (StringUtils.isEmpty((CharSequence)providerId)) {
            throw new IllegalArgumentException("CloudEventInputModel is missing an Adobe I/O Events providerId/source");
        }
        if (StringUtils.isEmpty((CharSequence)eventCode)) {
            throw new IllegalArgumentException("CloudEventInputModel is missing an Adobe I/O Events eventCode/type");
        }
        this.id = StringUtils.isEmpty((CharSequence)eventId) ? UUID.randomUUID().toString() : eventId;
        this.source = SOURCE_URN_PREFIX + providerId;
        this.type = eventCode;
        this.data = data;
    }

    public String getDataContentType() {
        return "application/json";
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public JsonNode getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEvent that = (CloudEvent)o;
        return Objects.equals("application/json", that.dataContentType) && Objects.equals(SPEC_VERSION, that.specVersion) && Objects.equals(this.source, that.source) && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash("application/json", SPEC_VERSION, this.source, this.type, this.id, this.data);
    }

    public String toString() {
        return "CloudEventInputModel{source='" + this.source + '\'' + ", type='" + this.type + '\'' + ", id='" + this.id + '\'' + ", data=" + this.data + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String providerId;
        private String eventCode;
        private String eventId;
        private JsonNode data;

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder eventCode(String eventCode) {
            this.eventCode = eventCode;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder data(JsonNode data) {
            this.data = data;
            return this;
        }

        public CloudEvent build() {
            return new CloudEvent(this.providerId, this.eventCode, this.eventId, this.data);
        }
    }
}

