/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.publish.feign;

import com.adobe.aio.event.publish.PublishService;
import com.adobe.aio.event.publish.api.PublishApi;
import com.adobe.aio.event.publish.model.CloudEvent;
import com.adobe.aio.exception.AIOException;
import com.adobe.aio.feign.AIOHeaderInterceptor;
import com.adobe.aio.ims.feign.AuthInterceptor;
import com.adobe.aio.util.JacksonUtil;
import com.adobe.aio.util.feign.FeignUtil;
import com.adobe.aio.workspace.Workspace;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import feign.RequestInterceptor;
import org.apache.commons.lang3.StringUtils;

public class FeignPublishService
implements PublishService {
    private final PublishApi publishApi;

    public FeignPublishService(Workspace workspace, String url) {
        String apiUrl;
        String string = apiUrl = StringUtils.isEmpty((CharSequence)url) ? "https://eventsingress.adobe.io" : url;
        if (workspace == null) {
            throw new IllegalArgumentException("PublishService is missing a workspace context");
        }
        workspace.validateWorkspaceContext();
        AuthInterceptor authInterceptor = AuthInterceptor.builder().workspace(workspace).build();
        this.publishApi = (PublishApi)FeignUtil.getDefaultBuilder().requestInterceptor((RequestInterceptor)authInterceptor).requestInterceptor((RequestInterceptor)AIOHeaderInterceptor.builder().workspace(workspace).build()).target(PublishApi.class, apiUrl);
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String data) throws JsonProcessingException {
        return this.publishCloudEvent(providerId, eventCode, null, JacksonUtil.getJsonNode((String)data));
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String eventId, String cloudEventData) throws JsonProcessingException {
        return this.publishCloudEvent(providerId, eventCode, eventId, JacksonUtil.getJsonNode((String)cloudEventData));
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String eventId, JsonNode cloudEventData) {
        return this.publishCloudEvent(false, providerId, eventCode, eventId, cloudEventData);
    }

    @Override
    public CloudEvent publishCloudEvent(Boolean isPhiData, String providerId, String eventCode, String eventId, JsonNode cloudEventData) {
        CloudEvent inputModel = CloudEvent.builder().providerId(providerId).eventCode(eventCode).eventId(eventId).data(cloudEventData).build();
        this.publishApi.publishCloudEvent(isPhiData, inputModel);
        return inputModel;
    }

    @Override
    public void publishRawEvent(String providerId, String eventCode, String rawEvent) {
        this.publishApi.publishRawEvent(false, providerId, eventCode, null, FeignPublishService.getJsonNode(rawEvent));
    }

    @Override
    public void publishRawEvent(Boolean isPhiData, String providerId, String eventCode, String eventId, String rawEvent) {
        if (isPhiData != null && isPhiData.booleanValue() && StringUtils.isEmpty((CharSequence)eventId)) {
            throw new AIOException("Cannot publish PHI data without an eventId");
        }
        this.publishApi.publishRawEvent(isPhiData, providerId, eventCode, eventId, FeignPublishService.getJsonNode(rawEvent));
    }

    private static JsonNode getJsonNode(String jsonPayload) {
        if (StringUtils.isEmpty((CharSequence)jsonPayload)) {
            return new ObjectMapper().createObjectNode();
        }
        if (jsonPayload.trim().startsWith("{")) {
            try {
                return new ObjectMapper().readTree(jsonPayload);
            }
            catch (JsonProcessingException e) {
                throw new AIOException("Invalid event json payload: " + e.getMessage(), (Throwable)e);
            }
        }
        return new TextNode(jsonPayload);
    }
}

