/*
 * Copyright 2017 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/*
 *
 *
 *
 *
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.adobe.event.management.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Adobe I/O Events Providers Collection Model
 */
public class ProviderCollection {

  @JsonProperty("_embedded")
  private ProviderList providerList;

  public ProviderList getProviderList() {
    return providerList;
  }

  @JsonIgnore
  public List<Provider> getProviders() {
    if (!this.isEmpty()) {
      return providerList.getProviders();
    } else {
      return new ArrayList<>();
    }
  }

  @JsonIgnore
  public boolean isEmpty() {
    return (providerList == null || providerList.isEmpty());
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProviderCollection that = (ProviderCollection) o;
    return Objects.equals(providerList, that.providerList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(providerList);
  }

  @Override
  public String toString() {
    return "ProviderCollection{" + providerList + '}';
  }

  public static class ProviderList {

    @JsonProperty("providers")
    private List<Provider> providers;

    /**
     * Adobe I/O Event Providers collection.
     *
     * @return providers
     **/
    public List<Provider> getProviders() {
      return providers;
    }

    @JsonIgnore
    public boolean isEmpty() {
      return (providers == null || providers.isEmpty());
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      ProviderList providerCollectionHalModelEmbedded = (ProviderList) o;
      return Objects.equals(this.providers, providerCollectionHalModelEmbedded.providers);
    }

    @Override
    public int hashCode() {
      return Objects.hash(providers);
    }

    @Override
    public String toString() {
      return "{" + providers + "}";
    }
  }
}
