/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.publish;

import com.adobe.aio.event.publish.PublishService;
import com.adobe.aio.event.publish.api.PublishApi;
import com.adobe.aio.event.publish.model.CloudEvent;
import com.adobe.aio.exception.AIOException;
import com.adobe.aio.util.FeignUtil;
import com.adobe.aio.util.JacksonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import feign.RequestInterceptor;
import org.apache.commons.lang3.StringUtils;

class PublishServiceImpl
implements PublishService {
    private final PublishApi publishApi;

    PublishServiceImpl(RequestInterceptor authInterceptor, String url) {
        String apiUrl;
        String string = apiUrl = StringUtils.isEmpty((CharSequence)url) ? "https://eventsingress.adobe.io" : url;
        if (authInterceptor == null) {
            throw new IllegalArgumentException("PublishService is missing a authentication interceptor");
        }
        this.publishApi = (PublishApi)FeignUtil.getDefaultBuilder().requestInterceptor(authInterceptor).target(PublishApi.class, apiUrl);
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String data) throws JsonProcessingException {
        return this.publishCloudEvent(providerId, eventCode, null, JacksonUtil.getJsonNode((String)data));
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String eventId, String data) throws JsonProcessingException {
        return this.publishCloudEvent(providerId, eventCode, eventId, JacksonUtil.getJsonNode((String)data));
    }

    @Override
    public CloudEvent publishCloudEvent(String providerId, String eventCode, String eventId, JsonNode data) {
        CloudEvent inputModel = CloudEvent.builder().providerId(providerId).eventCode(eventCode).eventId(eventId).data(data).build();
        this.publishApi.publishCloudEvent(inputModel);
        return inputModel;
    }

    @Override
    public void publishRawEvent(String providerId, String eventCode, String rawEvent) {
        this.publishApi.publishRawEvent(providerId, eventCode, PublishServiceImpl.getJsonNode(rawEvent));
    }

    private static JsonNode getJsonNode(String jsonPayload) {
        if (StringUtils.isEmpty((CharSequence)jsonPayload)) {
            return new ObjectMapper().createObjectNode();
        }
        if (jsonPayload.trim().startsWith("{")) {
            try {
                return new ObjectMapper().readTree(jsonPayload);
            }
            catch (JsonProcessingException e) {
                throw new AIOException("Invalid event json payload: " + e.getMessage(), (Throwable)e);
            }
        }
        return new TextNode(jsonPayload);
    }
}

