/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    private FileUtil() {
    }

    public static Map<String, String> getMapFromProperties(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    public static Optional<Properties> readPropertiesFromFile(String configFilePath) throws IOException {
        Optional<Properties> optional;
        if (StringUtils.isEmpty((CharSequence)configFilePath)) {
            return Optional.empty();
        }
        FileInputStream in = new FileInputStream(configFilePath);
        try {
            optional = Optional.of(FileUtil.read(in));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
        }
        ((InputStream)in).close();
        return optional;
    }

    public static Properties readPropertiesFromClassPath(String configClassPath) throws IOException {
        try (InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(configClassPath);){
            Properties properties = FileUtil.read(in);
            return properties;
        }
    }

    private static Properties read(InputStream in) throws IOException {
        Properties prop = new Properties();
        prop.load(in);
        in.close();
        return prop;
    }
}

