/*
 * Decompiled with CFR 0.152.
 */
package com.adobe;

import com.adobe.util.FileUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Workspace {
    static final String IMS_URL = "aio_ims_url";
    static final String IMS_ORG_ID = "aio_ims_org_id";
    static final String CONSUMER_ORG_ID = "aio_consumer_org_id";
    static final String PROJECT_ID = "aio_project_id";
    static final String WORKSPACE_ID = "aio_workspace_id";
    static final String API_KEY = "aio_api_key";
    static final String CREDENTIAL_ID = "aio_credential_id";
    static final String CLIENT_SECRET = "aio_client_secret";
    static final String TECHNICAL_ACCOUNT_ID = "aio_technical_account_id";
    static final String META_SCOPES = "aio_meta_scopes";
    private final String imsUrl;
    private final String imsOrgId;
    private final String apiKey;
    private final String credentialId;
    private final String clientSecret;
    private final String technicalAccountId;
    private final Set<String> metascopes;
    private final PrivateKey privateKey;
    private final String consumerOrgId;
    private final String projectId;
    private final String workspaceId;

    private Workspace(String imsUrl, String imsOrgId, String consumerOrgId, String projectId, String workspaceId, String apiKey, String credentialId, String clientSecret, String technicalAccountId, Set<String> metascopes, PrivateKey privateKey) {
        this.imsUrl = StringUtils.isEmpty((CharSequence)imsUrl) ? "https://ims-na1.adobelogin.com" : imsUrl;
        this.imsOrgId = imsOrgId;
        this.apiKey = apiKey;
        this.credentialId = credentialId;
        this.clientSecret = clientSecret;
        this.technicalAccountId = technicalAccountId;
        this.metascopes = metascopes;
        this.privateKey = privateKey;
        this.consumerOrgId = consumerOrgId;
        this.projectId = projectId;
        this.workspaceId = workspaceId;
    }

    public void validateJwtCredentialConfig() {
        if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("Your `Worskpace` is missing an apiKey");
        }
        if (StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a clientSecret");
        }
        if (StringUtils.isEmpty((CharSequence)this.imsOrgId)) {
            throw new IllegalArgumentException("Your `Worskpace` is missing an imsOrgId");
        }
        if (StringUtils.isEmpty((CharSequence)this.technicalAccountId)) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a technicalAccountId");
        }
        if (this.metascopes.isEmpty()) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a metascope");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a privateKey");
        }
    }

    public void validateWorkspaceContext() {
        if (StringUtils.isEmpty((CharSequence)this.getConsumerOrgId())) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a consumerOrgId");
        }
        if (StringUtils.isEmpty((CharSequence)this.getProjectId())) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a projectId");
        }
        if (StringUtils.isEmpty((CharSequence)this.getWorkspaceId())) {
            throw new IllegalArgumentException("Your `Worskpace` is missing a workspaceId");
        }
    }

    public String getImsUrl() {
        return this.imsUrl;
    }

    public String getImsOrgId() {
        return this.imsOrgId;
    }

    public String getConsumerOrgId() {
        return this.consumerOrgId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTechnicalAccountId() {
        return this.technicalAccountId;
    }

    public Set<String> getMetascopes() {
        return this.metascopes;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.imsUrl, workspace.imsUrl) && Objects.equals(this.imsOrgId, workspace.imsOrgId) && Objects.equals(this.consumerOrgId, workspace.consumerOrgId) && Objects.equals(this.projectId, workspace.projectId) && Objects.equals(this.workspaceId, workspace.workspaceId) && Objects.equals(this.apiKey, workspace.apiKey) && Objects.equals(this.credentialId, workspace.credentialId) && Objects.equals(this.clientSecret, workspace.clientSecret) && Objects.equals(this.technicalAccountId, workspace.technicalAccountId) && Objects.equals(this.metascopes, workspace.metascopes) && Objects.equals(this.privateKey, workspace.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.imsUrl, this.imsOrgId, this.consumerOrgId, this.projectId, this.workspaceId, this.apiKey, this.credentialId, this.clientSecret, this.technicalAccountId, this.metascopes, this.privateKey);
    }

    public String toString() {
        return "Workspace{imsUrl='" + this.imsUrl + "', imsOrgId='" + this.imsOrgId + "', consumerOrgId='" + this.consumerOrgId + "', projectId='" + this.projectId + "', workspaceId='" + this.workspaceId + "', apiKey='" + this.apiKey + "', credentialId='" + this.credentialId + "', clientSecret='" + this.clientSecret + "', technicalAccountId='" + this.technicalAccountId + "', metascopes=" + this.metascopes + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String imsUrl;
        private String imsOrgId;
        private String consumerOrgId;
        private String projectId;
        private String workspaceId;
        private String apiKey;
        private String credentialId;
        private String clientSecret;
        private String technicalAccountId;
        private final Set<String> metascopes = new HashSet<String>();
        private PrivateKey privateKey;
        private Map<String, String> workspaceProperties;

        private Builder() {
        }

        public Builder imsUrl(String imsUrl) {
            this.imsUrl = imsUrl;
            return this;
        }

        public Builder imsOrgId(String imsOrgId) {
            this.imsOrgId = imsOrgId;
            return this;
        }

        public Builder consumerOrgId(String consumerOrgId) {
            this.consumerOrgId = consumerOrgId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder technicalAccountId(String technicalAccountId) {
            this.technicalAccountId = technicalAccountId;
            return this;
        }

        public Builder addMetascope(String metascope) {
            this.metascopes.add(metascope);
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder configMap(Map<String, String> configMap) {
            this.imsUrl(configMap.get(Workspace.IMS_URL)).imsOrgId(configMap.get(Workspace.IMS_ORG_ID)).consumerOrgId(configMap.get(Workspace.CONSUMER_ORG_ID)).projectId(configMap.get(Workspace.PROJECT_ID)).workspaceId(configMap.get(Workspace.WORKSPACE_ID)).apiKey(configMap.get(Workspace.API_KEY)).credentialId(configMap.get(Workspace.CREDENTIAL_ID)).clientSecret(configMap.get(Workspace.CLIENT_SECRET)).technicalAccountId(configMap.get(Workspace.TECHNICAL_ACCOUNT_ID));
            if (!StringUtils.isEmpty((CharSequence)configMap.get(Workspace.META_SCOPES))) {
                String[] metascopeArray;
                for (String metascope : metascopeArray = configMap.get(Workspace.META_SCOPES).split(",")) {
                    this.addMetascope(metascope);
                }
            }
            return this;
        }

        public Builder systemEnv() {
            return this.configMap(System.getenv());
        }

        public Builder propertiesPath(String propertiesPath) throws IOException {
            return this.properties(FileUtil.readPropertiesFromFile(propertiesPath).orElse(FileUtil.readPropertiesFromClassPath(propertiesPath)));
        }

        public Builder properties(Properties properties) throws IOException {
            return this.configMap(FileUtil.getMapFromProperties(properties));
        }

        public Workspace build() {
            return new Workspace(this.imsUrl, this.imsOrgId, this.consumerOrgId, this.projectId, this.workspaceId, this.apiKey, this.credentialId, this.clientSecret, this.technicalAccountId, this.metascopes, this.privateKey);
        }
    }
}

