/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.skie.kir.descriptor;

import co.touchlab.skie.configuration.ClassConfiguration;
import co.touchlab.skie.configuration.ClassInterop;
import co.touchlab.skie.configuration.ConfigurationKey;
import co.touchlab.skie.configuration.FileConfiguration;
import co.touchlab.skie.configuration.FileOrClassConfiguration;
import co.touchlab.skie.configuration.ModuleConfiguration;
import co.touchlab.skie.configuration.PackageConfiguration;
import co.touchlab.skie.configuration.RootConfiguration;
import co.touchlab.skie.configuration.provider.descriptor.DescriptorConfigurationProvider;
import co.touchlab.skie.kir.descriptor.DescriptorKirProvider;
import co.touchlab.skie.kir.element.KirClass;
import co.touchlab.skie.kir.element.KirClassParent;
import co.touchlab.skie.kir.element.KirModule;
import co.touchlab.skie.kir.element.KirProject;
import co.touchlab.skie.phases.kir.CreateExposedKirTypesPhase;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017H\u0002J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001aJ\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001aJ\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\"H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001c2\u0006\u0010)\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u001aH\u0002R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\u001c*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00020\"*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0018\u0010$\u001a\u00020\"*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010#\u00a8\u0006."}, d2={"Lco/touchlab/skie/kir/descriptor/ExternalDescriptorKirProvider;", "", "kirProject", "Lco/touchlab/skie/kir/element/KirProject;", "rootConfiguration", "Lco/touchlab/skie/configuration/RootConfiguration;", "descriptorConfigurationProvider", "Lco/touchlab/skie/configuration/provider/descriptor/DescriptorConfigurationProvider;", "descriptorKirProvider", "Lkotlin/Lazy;", "Lco/touchlab/skie/kir/descriptor/DescriptorKirProvider;", "(Lco/touchlab/skie/kir/element/KirProject;Lco/touchlab/skie/configuration/RootConfiguration;Lco/touchlab/skie/configuration/provider/descriptor/DescriptorConfigurationProvider;Lkotlin/Lazy;)V", "allExternalClassesAndProtocols", "", "Lco/touchlab/skie/kir/element/KirClass;", "getAllExternalClassesAndProtocols", "()Ljava/util/Collection;", "getDescriptorKirProvider", "()Lco/touchlab/skie/kir/descriptor/DescriptorKirProvider;", "descriptorKirProvider$delegate", "Lkotlin/Lazy;", "externalClassParentConfigurationByModule", "", "Lco/touchlab/skie/kir/element/KirModule;", "Lco/touchlab/skie/configuration/FileOrClassConfiguration;", "externalClassesAndProtocolsCache", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "externalModulesByName", "", "unknownModule", "cinteropFrameworkNameForWellKnownExternalType", "getCinteropFrameworkNameForWellKnownExternalType", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/lang/String;", "isCocoapodsType", "", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "isPlatformType", "createClassConfiguration", "Lco/touchlab/skie/configuration/ClassConfiguration;", "module", "getExternalBuiltinClass", "descriptor", "getExternalClass", "addNSObjectSuperType", "getExternalClassSwiftFrameworkName", "getExternalModule", "kotlin-compiler-linker-plugin"})
@SourceDebugExtension(value={"SMAP\nExternalDescriptorKirProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalDescriptorKirProvider.kt\nco/touchlab/skie/kir/descriptor/ExternalDescriptorKirProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,133:1\n372#2,3:134\n375#2,4:138\n372#2,7:142\n372#2,7:149\n34#3:137\n*S KotlinDebug\n*F\n+ 1 ExternalDescriptorKirProvider.kt\nco/touchlab/skie/kir/descriptor/ExternalDescriptorKirProvider\n*L\n52#1:134,3\n52#1:138,4\n89#1:142,7\n126#1:149,7\n53#1:137\n*E\n"})
public final class ExternalDescriptorKirProvider {
    @NotNull
    private final KirProject kirProject;
    @NotNull
    private final RootConfiguration rootConfiguration;
    @NotNull
    private final DescriptorConfigurationProvider descriptorConfigurationProvider;
    @NotNull
    private final Map<ClassDescriptor, KirClass> externalClassesAndProtocolsCache;
    @NotNull
    private final Map<String, KirModule> externalModulesByName;
    @NotNull
    private final Lazy descriptorKirProvider$delegate;
    @NotNull
    private final KirModule unknownModule;
    @NotNull
    private final Map<KirModule, FileOrClassConfiguration> externalClassParentConfigurationByModule;

    public ExternalDescriptorKirProvider(@NotNull KirProject kirProject, @NotNull RootConfiguration rootConfiguration, @NotNull DescriptorConfigurationProvider descriptorConfigurationProvider, @NotNull Lazy<DescriptorKirProvider> descriptorKirProvider) {
        Intrinsics.checkNotNullParameter((Object)kirProject, (String)"kirProject");
        Intrinsics.checkNotNullParameter((Object)rootConfiguration, (String)"rootConfiguration");
        Intrinsics.checkNotNullParameter((Object)descriptorConfigurationProvider, (String)"descriptorConfigurationProvider");
        Intrinsics.checkNotNullParameter(descriptorKirProvider, (String)"descriptorKirProvider");
        this.kirProject = kirProject;
        this.rootConfiguration = rootConfiguration;
        this.descriptorConfigurationProvider = descriptorConfigurationProvider;
        this.externalClassesAndProtocolsCache = new LinkedHashMap();
        this.externalModulesByName = new LinkedHashMap();
        this.descriptorKirProvider$delegate = descriptorKirProvider;
        this.unknownModule = new KirModule("<unknown>", this.kirProject, new ModuleConfiguration(this.rootConfiguration), KirModule.Origin.UnknownExternal);
        this.externalClassParentConfigurationByModule = new LinkedHashMap();
    }

    @NotNull
    public final Collection<KirClass> getAllExternalClassesAndProtocols() {
        return this.externalClassesAndProtocolsCache.values();
    }

    private final DescriptorKirProvider getDescriptorKirProvider() {
        Lazy lazy = this.descriptorKirProvider$delegate;
        return (DescriptorKirProvider)lazy.getValue();
    }

    @NotNull
    public final KirClass getExternalClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.getExternalClass(descriptor2, true);
    }

    @NotNull
    public final KirClass getExternalBuiltinClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.getExternalClass(descriptor2, false);
    }

    /*
     * WARNING - void declaration
     */
    private final KirClass getExternalClass(ClassDescriptor descriptor2, boolean addNSObjectSuperType) {
        Object object;
        void $this$getOrPut$iv;
        Map<ClassDescriptor, KirClass> map = this.externalClassesAndProtocolsCache;
        ClassDescriptor classDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor.original");
        ClassDescriptor key$iv = classDescriptor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Pair pair;
            boolean bl = false;
            ClassKind classKind = descriptor2.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)classKind, (String)"descriptor.kind");
            ClassKind $this$isInterface$iv = classKind;
            boolean $i$f$isInterface = false;
            if ($this$isInterface$iv == ClassKind.INTERFACE) {
                String string = descriptor2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
                pair = TuplesKt.to((Object)StringsKt.removeSuffix((String)string, (CharSequence)"Protocol"), (Object)KirClass.Kind.Interface);
            } else {
                pair = TuplesKt.to((Object)descriptor2.getName().asString(), (Object)KirClass.Kind.Class);
            }
            Pair pair2 = pair;
            String name = (String)pair2.component1();
            KirClass.Kind kind = (KirClass.Kind)pair2.component2();
            KirModule module = this.getExternalModule(descriptor2);
            String string = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.fqNameSafe.asString()");
            KirClass kirClass = new KirClass(string, name, name, (KirClassParent)module, kind, this.isPlatformType(descriptor2) ? (KirClass.Origin)KirClass.Origin.PlatformType.INSTANCE : (KirClass.Origin)KirClass.Origin.ExternalCinteropType.INSTANCE, addNSObjectSuperType && kind != KirClass.Kind.Interface ? CollectionsKt.listOf((Object)this.getDescriptorKirProvider().getKirBuiltins().getNSObject().getDefaultType()) : CollectionsKt.emptyList(), false, false, CreateExposedKirTypesPhase.Companion.getNestingLevel(descriptor2), this.createClassConfiguration(module));
            this.getDescriptorKirProvider().registerClass(kirClass, descriptor2);
            KirClass answer$iv = kirClass;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (KirClass)object;
    }

    private final KirModule getExternalModule(ClassDescriptor descriptor2) {
        KirModule kirModule;
        String string = this.getExternalClassSwiftFrameworkName(descriptor2);
        if (string == null) {
            return this.unknownModule;
        }
        String swiftFrameworkName = string;
        Map<String, KirModule> $this$getOrPut$iv = this.externalModulesByName;
        boolean $i$f$getOrPut = false;
        KirModule value$iv = $this$getOrPut$iv.get(swiftFrameworkName);
        if (value$iv == null) {
            boolean bl = false;
            KirModule answer$iv = new KirModule(swiftFrameworkName, this.kirProject, new ModuleConfiguration(this.rootConfiguration), KirModule.Origin.KnownExternal);
            $this$getOrPut$iv.put(swiftFrameworkName, answer$iv);
            kirModule = answer$iv;
        } else {
            kirModule = value$iv;
        }
        return kirModule;
    }

    private final String getExternalClassSwiftFrameworkName(ClassDescriptor descriptor2) {
        ClassConfiguration configuration = this.descriptorConfigurationProvider.getConfiguration(descriptor2);
        String string = (String)configuration.get((ConfigurationKey)ClassInterop.CInteropFrameworkName.INSTANCE);
        if (string == null) {
            string = this.isPlatformType(descriptor2) ? this.getCinteropFrameworkNameForWellKnownExternalType(descriptor2) : (this.isCocoapodsType(descriptor2) && (Boolean)configuration.get((ConfigurationKey)ClassInterop.DeriveCInteropFrameworkNameFromCocoapods.INSTANCE) != false ? this.getCinteropFrameworkNameForWellKnownExternalType(descriptor2) : null);
        }
        return string;
    }

    private final boolean isPlatformType(ClassDescriptor $this$isPlatformType) {
        return Intrinsics.areEqual((Object)((Name)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$isPlatformType)).pathSegments().get(0)).asString(), (Object)"platform");
    }

    private final boolean isCocoapodsType(ClassDescriptor $this$isCocoapodsType) {
        return Intrinsics.areEqual((Object)((Name)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$isCocoapodsType)).pathSegments().get(0)).asString(), (Object)"cocoapods");
    }

    private final String getCinteropFrameworkNameForWellKnownExternalType(ClassDescriptor $this$cinteropFrameworkNameForWellKnownExternalType) {
        String string;
        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$cinteropFrameworkNameForWellKnownExternalType)).shortName().asString(), (Object)"NSObject")) {
            String string2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$cinteropFrameworkNameForWellKnownExternalType)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.fqNameUnsafe.asString()");
            String[] stringArray = new String[]{"."};
            string = (String)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        } else {
            string = "Foundation";
        }
        return string;
    }

    private final ClassConfiguration createClassConfiguration(KirModule module) {
        FileOrClassConfiguration fileOrClassConfiguration;
        Map<KirModule, FileOrClassConfiguration> $this$getOrPut$iv = this.externalClassParentConfigurationByModule;
        boolean $i$f$getOrPut = false;
        FileOrClassConfiguration value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            FileOrClassConfiguration answer$iv = (FileOrClassConfiguration)new FileOrClassConfiguration.File(new FileConfiguration(new PackageConfiguration(module.getConfiguration())));
            $this$getOrPut$iv.put(module, answer$iv);
            fileOrClassConfiguration = answer$iv;
        } else {
            fileOrClassConfiguration = value$iv;
        }
        FileOrClassConfiguration parentConfiguration = fileOrClassConfiguration;
        return new ClassConfiguration(parentConfiguration);
    }
}

