/*
 * Decompiled with CFR 0.152.
 */
package com.tamara.sdk.notification;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tamara.sdk.configuration.ApiConfiguration;
import com.tamara.sdk.logger.ApiLogger;
import com.tamara.sdk.models.consumer.ApiMeta;
import com.tamara.sdk.models.consumer.ApiResponse;
import com.tamara.sdk.models.notification.AuthoriseMessage;
import com.tamara.sdk.models.notification.WebhookMessage;
import com.tamara.sdk.notification.ITamaraNotificationService;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class TamaraNotificationService
implements ITamaraNotificationService {
    private ApiLogger _logger;
    private final String _privateKey;

    public TamaraNotificationService(ApiConfiguration config) {
        this._logger = new ApiLogger(config);
        this._privateKey = config.notificationPrivateKey;
    }

    @Override
    public ApiResponse<AuthoriseMessage> processAuthoriseNotification(HttpURLConnection request) {
        ApiResponse<AuthoriseMessage> response = this.processWebhook(request, AuthoriseMessage.class);
        return response;
    }

    @Override
    public ApiResponse<AuthoriseMessage> processAuthoriseNotification(InputStream requestData, String requestToken) {
        ApiResponse response = new ApiResponse();
        if (this.authenticate(requestToken)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                AuthoriseMessage webhookMsg = (AuthoriseMessage)mapper.readValue(requestData, AuthoriseMessage.class);
                response.setData((Object)webhookMsg);
                return response;
            }
            catch (Exception e) {
                this._logger.Error(e.getMessage());
            }
        }
        response.setMeta(ApiMeta.Failed((int)412, (String)"ForbiddenException"));
        return response;
    }

    @Override
    public ApiResponse<WebhookMessage> processWebhook(HttpURLConnection request) {
        ApiResponse<WebhookMessage> response = this.processWebhook(request, WebhookMessage.class);
        return response;
    }

    @Override
    public ApiResponse<WebhookMessage> processWebhook(InputStream requestData, String requestToken) {
        ApiResponse response = new ApiResponse();
        if (this.authenticate(requestToken)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                WebhookMessage webhookMsg = (WebhookMessage)mapper.readValue(requestData, WebhookMessage.class);
                response.setData((Object)webhookMsg);
                return response;
            }
            catch (Exception e) {
                this._logger.Error(e.getMessage());
            }
        }
        response.setMeta(ApiMeta.Failed((int)412, (String)"ForbiddenException"));
        return response;
    }

    private <T> ApiResponse<T> processWebhook(HttpURLConnection request, Class<T> responseType) {
        ApiResponse response = new ApiResponse();
        if (!"post".equalsIgnoreCase(request.getRequestMethod())) {
            response.setMeta(ApiMeta.Failed((int)402, (String)"Method is not allowed"));
            this._logger.Error("ProcessWebhook: Method is not allowed");
            return response;
        }
        if (this.authenticate(request)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Object types = mapper.readValue(request.getInputStream(), responseType);
                response.setData(types);
            }
            catch (Exception e) {
                this._logger.Error(e.getMessage());
            }
        }
        response.setMeta(ApiMeta.Failed((int)412, (String)"ForbiddenException"));
        return response;
    }

    private String getAuthorizationString(HttpURLConnection request) {
        String auth = request.getRequestProperty("Authorization");
        if (auth != null && auth.length() > 0) {
            if (auth.startsWith("Bearer")) {
                auth = auth.substring("Bearer ".length());
            }
            return auth;
        }
        return "";
    }

    private boolean authenticate(HttpURLConnection request) {
        String requestToken = this.getAuthorizationString(request);
        return this.authenticate(requestToken);
    }

    @Override
    public boolean authenticate(String requestToken) {
        try {
            if (requestToken.length() > 0) {
                if (requestToken.startsWith("Bearer")) {
                    requestToken = requestToken.substring("Bearer ".length());
                }
                Algorithm algorithm = Algorithm.HMAC256((String)this._privateKey);
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                verifier.verify(requestToken);
                return true;
            }
        }
        catch (Exception e) {
            this._logger.Error(e.getMessage());
        }
        return false;
    }
}

