/*
 * Decompiled with CFR 0.152.
 */
package com.tamara.sdk.consumer;

import com.tamara.sdk.configuration.ApiConfiguration;
import com.tamara.sdk.consumer.BaseApiClient;
import com.tamara.sdk.consumer.ITamaraApiClient;
import com.tamara.sdk.models.consumer.ApiRequest;
import com.tamara.sdk.models.consumer.ApiResponse;
import com.tamara.sdk.models.order.AuthoriseOrderResponse;
import com.tamara.sdk.models.order.CancelOrderRequest;
import com.tamara.sdk.models.order.CancelOrderResponse;
import com.tamara.sdk.models.order.CheckoutResponse;
import com.tamara.sdk.models.order.Order;
import com.tamara.sdk.models.order.OrderDetail;
import com.tamara.sdk.models.order.UpdateOrderReferenceIdRequest;
import com.tamara.sdk.models.order.UpdateOrderReferenceIdResponse;
import com.tamara.sdk.models.payment.CaptureRequest;
import com.tamara.sdk.models.payment.CaptureResponse;
import com.tamara.sdk.models.payment.PaymentType;
import com.tamara.sdk.models.payment.RefundRequest;
import com.tamara.sdk.models.payment.RefundResponse;
import com.tamara.sdk.models.webhook.RemoveWebhookResponse;
import com.tamara.sdk.models.webhook.WebhookData;
import com.tamara.sdk.models.webhook.WebhookRequest;

public class TamaraApiClient
extends BaseApiClient
implements ITamaraApiClient {
    public TamaraApiClient(ApiConfiguration config) {
        super(config);
    }

    @Override
    public ApiResponse<PaymentType[]> getPaymentTypes(String countryCode) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.getPaymentType);
        apiRequest.addParams("country", countryCode);
        ApiResponse<PaymentType[]> response = this.execute(apiRequest, PaymentType[].class);
        return response;
    }

    @Override
    public ApiResponse<CheckoutResponse> createCheckout(Order order) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.createCheckout);
        apiRequest.setMethod("POST");
        apiRequest.setData((Object)order);
        ApiResponse<CheckoutResponse> response = this.execute(apiRequest, CheckoutResponse.class);
        return response;
    }

    @Override
    public ApiResponse<AuthoriseOrderResponse> authoriseOrder(String orderId) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.authoriseOrder);
        apiRequest.setMethod("POST");
        apiRequest.addParams("orderId", orderId);
        ApiResponse<AuthoriseOrderResponse> response = this.execute(apiRequest, AuthoriseOrderResponse.class);
        return response;
    }

    @Override
    public ApiResponse<CancelOrderResponse> cancelOrder(CancelOrderRequest request) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.cancelOrder);
        apiRequest.setMethod("POST");
        apiRequest.addParams("orderId", request.getOrderId());
        apiRequest.setData((Object)request);
        ApiResponse<CancelOrderResponse> response = this.execute(apiRequest, CancelOrderResponse.class);
        return response;
    }

    @Override
    public ApiResponse<CaptureResponse> capture(CaptureRequest request) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.capture);
        apiRequest.setMethod("POST");
        apiRequest.setData((Object)request);
        ApiResponse<CaptureResponse> response = this.execute(apiRequest, CaptureResponse.class);
        return response;
    }

    @Override
    public ApiResponse<RefundResponse> refund(RefundRequest request) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.refund);
        apiRequest.setMethod("POST");
        apiRequest.setData((Object)request);
        ApiResponse<RefundResponse> response = this.execute(apiRequest, RefundResponse.class);
        return response;
    }

    @Override
    public ApiResponse<OrderDetail> getOrderDetails(String orderId) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.getOrderDetails);
        apiRequest.addParams("orderId", orderId);
        ApiResponse<OrderDetail> response = this.execute(apiRequest, OrderDetail.class);
        return response;
    }

    @Override
    public ApiResponse<OrderDetail> getOrderDetailsByReference(String orderReferenceId) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.getOrderDetailsByRef);
        apiRequest.addParams("orderReferenceId", orderReferenceId);
        ApiResponse<OrderDetail> response = this.execute(apiRequest, OrderDetail.class);
        return response;
    }

    @Override
    public ApiResponse<UpdateOrderReferenceIdResponse> updateOrderReferenceId(UpdateOrderReferenceIdRequest request) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.updateOrderReferenceId);
        apiRequest.setMethod("PUT");
        apiRequest.addParams("orderId", request.getOrderId());
        apiRequest.setData((Object)request);
        ApiResponse<UpdateOrderReferenceIdResponse> response = this.execute(apiRequest, UpdateOrderReferenceIdResponse.class);
        return response;
    }

    @Override
    public ApiResponse<WebhookData> registerWebhook(WebhookRequest webHookRequest) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.registerWebHook);
        apiRequest.setMethod("POST");
        apiRequest.setData((Object)webHookRequest);
        ApiResponse<WebhookData> response = this.execute(apiRequest, WebhookData.class);
        return response;
    }

    @Override
    public ApiResponse<WebhookData> retrieveWebhook(String webhookId) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.retrieveWebhook);
        apiRequest.addParams("webhookId", webhookId);
        ApiResponse<WebhookData> response = this.execute(apiRequest, WebhookData.class);
        return response;
    }

    @Override
    public ApiResponse<RemoveWebhookResponse> removeWebhook(String webhookId) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.removeWebhook);
        apiRequest.setMethod("DELETE");
        apiRequest.addParams("webhookId", webhookId);
        ApiResponse<RemoveWebhookResponse> response = this.execute(apiRequest, RemoveWebhookResponse.class);
        return response;
    }

    @Override
    public ApiResponse<WebhookData> updateWebhook(WebhookData webHookRequest) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setPath(this._configuration.paths.updateWebhook);
        apiRequest.setMethod("PUT");
        apiRequest.setData((Object)webHookRequest);
        apiRequest.addParams("webhookId", webHookRequest.getWebhookId());
        ApiResponse<WebhookData> response = this.execute(apiRequest, WebhookData.class);
        return response;
    }
}

