/*
 * Decompiled with CFR 0.152.
 */
package com.tamara.sdk.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tamara.sdk.configuration.ApiConfiguration;
import com.tamara.sdk.logger.ApiLogger;
import com.tamara.sdk.models.consumer.ApiMeta;
import com.tamara.sdk.models.consumer.ApiRequest;
import com.tamara.sdk.models.consumer.ApiResponse;
import com.tamara.sdk.models.exception.ExceptionResponse;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class BaseApiClient {
    protected ApiConfiguration _configuration;
    protected ApiLogger _logger;

    public BaseApiClient(ApiConfiguration config) {
        this._configuration = config;
        this._logger = new ApiLogger(config);
    }

    protected <T> ApiResponse<T> execute(ApiRequest request, Class<T> responseType) {
        try {
            URL url = new URL(this._configuration.baseUrl);
            url = new URL(url, request.buildRequestUrl());
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try {
                ObjectMapper mapper;
                con.setRequestMethod(request.getMethod());
                con.setRequestProperty("Accept", "application/json");
                con.addRequestProperty("Authorization", "Bearer " + this._configuration.apiToken);
                con.addRequestProperty("User-Agent", "Tamara Client SDK " + this._configuration.clientVersion);
                con.setDoOutput(true);
                if (request.getData() != null) {
                    con.setRequestProperty("Content-Type", "application/json; utf-8");
                    mapper = new ObjectMapper();
                    mapper.setDateFormat((DateFormat)new SimpleDateFormat("dd-MM-yyyy hh:mm:ss"));
                    byte[] requestData = mapper.writeValueAsBytes(request.getData());
                    String s = new String(requestData, StandardCharsets.UTF_8);
                    this._logger.Info(s);
                    try (OutputStream os = con.getOutputStream();){
                        os.write(requestData, 0, requestData.length);
                    }
                }
                mapper = new ObjectMapper();
                Object types = mapper.readValue(con.getInputStream(), responseType);
                ApiResponse response = new ApiResponse();
                response.setData(types);
                this._logger.Info(response);
                return response;
            }
            catch (Exception ex) {
                if (con.getResponseCode() < 200 || con.getResponseCode() > 299) {
                    ObjectMapper mapper = new ObjectMapper();
                    ExceptionResponse error = (ExceptionResponse)mapper.readValue(con.getErrorStream(), ExceptionResponse.class);
                    ApiResponse response = new ApiResponse();
                    response.setMeta(ApiMeta.Failed((int)con.getResponseCode(), (String)error.getMessage(), (String[])error.getErrorCodes()));
                    this._logger.Error(response);
                    return response;
                }
            }
        }
        catch (Exception e) {
            ApiResponse response = new ApiResponse();
            response.setMeta(ApiMeta.Failed((int)500, (String)"Internal Server Error."));
            this._logger.Error(e);
            return response;
        }
        ApiResponse response = new ApiResponse();
        response.setMeta(ApiMeta.Failed((int)500, (String)"Response empty."));
        this._logger.Error(response);
        return response;
    }
}

