package co.saltpay.epos.request.handlerlib.events

import co.saltpay.epos.models.request.BackgroundRequest

internal sealed interface SenderBackgroundRequest {

    val requestingPackage: String

    val requestingLibVersion: String

    val requestId: String

    data class Valid(
        val backgroundRequest: BackgroundRequest,
        override val requestingPackage: String,
        override val requestingLibVersion: String,
        override val requestId: String
    ): SenderBackgroundRequest

    data class Invalid(
        override val requestingPackage: String,
        override val requestingLibVersion: String,
        override val requestId: String
    ): SenderBackgroundRequest
}