@file:Suppress("unused", "ObjectPropertyName")

package co.saltpay.epos.request.handlerlib.di

import co.saltpay.epos.request.handlerlib.EposRequestHandler

internal interface CompositionRootAccessor

internal val CompositionRootAccessor.compositionRoot: CompositionRoot
    get() = _compositionRoot
        ?: throw IllegalStateException(
            "You need to call ${EposRequestHandler::class.simpleName}.init on Application's onCreate method!"
        )


// backing field initialisation
private var _compositionRoot: CompositionRootImpl? = null

internal fun prepareRootAccessor(root: CompositionRootImpl) {
    _compositionRoot = root
}