package co.saltpay.epos.request.handlerlib

import android.app.Application
import co.saltpay.epos.models.mappers.toIntent
import co.saltpay.epos.models.response.LibrariesVersionMismatch
import co.saltpay.epos.request.handlerlib.events.BroadcastEventsSubscriber
import co.saltpay.epos.request.handlerlib.events.SenderBackgroundRequest
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import co.saltpay.epos.models.mappers.BuildConfig as MappersBuildConfig

internal class InternalEposRequestHandler(
    processScope: CoroutineScope,
    private val app: Application,
    private val eventsSubscriber: BroadcastEventsSubscriber,
    private val backgroundRequestHandler: () -> BackgroundRequestHandler
) {

    init {
        processScope.launch {
            eventsSubscriber.requestsFlow.collect {
                handle(it)
            }
        }
    }

    private suspend fun handle(request: SenderBackgroundRequest) {
        when (request) {
            is SenderBackgroundRequest.Invalid -> {
                val response = LibrariesVersionMismatch(
                    requestId = request.requestId,
                    eposLibVersion = request.requestingLibVersion,
                    payAppLibVersion = MappersBuildConfig.VERSION_NAME
                )
                val intent = response.toIntent(
                    request.requestingPackage,
                    request.requestingLibVersion
                )
                app.sendBroadcast(intent)
            }

            is SenderBackgroundRequest.Valid -> {
                val response = backgroundRequestHandler().handle(
                    request.backgroundRequest,
                    request.requestingPackage
                )
                val intent = response.toIntent(
                    request.requestingPackage,
                    request.requestingLibVersion
                )
                app.sendBroadcast(intent)
            }
        }
    }
}