package co.saltpay.epos.request.handlerlib

import android.app.Application
import android.content.Intent
import co.saltpay.epos.models.request.ForegroundRequest
import co.saltpay.epos.request.handlerlib.di.CompositionRootAccessor
import co.saltpay.epos.request.handlerlib.di.CompositionRootImpl
import co.saltpay.epos.request.handlerlib.di.compositionRoot
import co.saltpay.epos.request.handlerlib.di.prepareRootAccessor
import co.saltpay.epos.models.mappers.BuildConfig as MappersBuildConfig

public object EposRequestHandler: CompositionRootAccessor {

    public fun init(
        app: Application,
        logger: Logger,
        requestHandler: () -> BackgroundRequestHandler
    ) {
        val root = CompositionRootImpl(app, logger, requestHandler)
        root.logger.i("EposRequestHandler", "init called - version ${MappersBuildConfig.VERSION_NAME}")

        prepareRootAccessor(root)
    }

    public fun processForegroundIntent(
        goToBackground: () -> Unit,
        intent: Intent,
        handlerProvider: (ForegroundRequest) -> ForegroundRequestHandler
    ) {
        compositionRoot.foregroundRequestProcessor.process(goToBackground, intent, handlerProvider)
    }
}

