package co.saltpay.epos.request.handlerlib.di

import android.app.Application
import co.saltpay.epos.request.handlerlib.InternalEposRequestHandler
import co.saltpay.epos.request.handlerlib.BackgroundRequestHandler
import co.saltpay.epos.request.handlerlib.ForegroundRequestProcessor
import co.saltpay.epos.request.handlerlib.Logger
import co.saltpay.epos.request.handlerlib.events.BroadcastEventPubSub
import co.saltpay.epos.request.handlerlib.events.BroadcastEventsPublisher
import co.saltpay.epos.request.handlerlib.events.BroadcastEventsSubscriber
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope

internal interface CompositionRoot {

    val app: Application

    val logger: Logger

    val processScope: CoroutineScope

    val eventsPublisher: BroadcastEventsPublisher

    val eventsSubscriber: BroadcastEventsSubscriber

    val eposIntegrationApi: InternalEposRequestHandler

    val foregroundRequestProcessor: ForegroundRequestProcessor

    val backgroundHandler: () -> BackgroundRequestHandler
}

internal class CompositionRootImpl(
    override val app: Application,
    override val logger: Logger,
    override val backgroundHandler: () -> BackgroundRequestHandler,
): CompositionRoot {

    // we want this background work to be alive throughout the whole process, so this is correct
    @OptIn(DelicateCoroutinesApi::class)
    override val processScope: CoroutineScope = GlobalScope

    override val eventsPublisher: BroadcastEventsPublisher = BroadcastEventPubSub

    override val eventsSubscriber: BroadcastEventsSubscriber = BroadcastEventPubSub

    override val eposIntegrationApi: InternalEposRequestHandler =
        InternalEposRequestHandler(
            processScope,
            app,
            eventsSubscriber,
            backgroundHandler
        )

    override val foregroundRequestProcessor: ForegroundRequestProcessor =
        ForegroundRequestProcessor(
            processScope,
            app,
            logger
        )
}