package co.saltpay.epos.request.handlerlib

import java.io.PrintWriter
import java.io.StringWriter

public interface Logger {

    public fun i(tag: String, message: String)

    public fun w(tag: String, message: String)

    public fun e(tag: String, message: String)

}

internal fun Throwable.asLog(): String {

    return StringWriter(256).use { stringWriter ->
        PrintWriter(stringWriter, false).use { printWriter ->
            printStackTrace(printWriter)
            printWriter.flush()
        }
        stringWriter.toString()
    }
}