/*
 * Decompiled with CFR 0.152.
 */
package co.nlighten.jsontransform.functions;

import co.nlighten.jsontransform.functions.ArgType;
import co.nlighten.jsontransform.functions.FunctionContext;
import co.nlighten.jsontransform.functions.annotations.ArgumentType;
import co.nlighten.jsontransform.functions.annotations.InputType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class TransformerFunction<T extends FunctionContext> {
    protected final InputType inputType;
    protected final Map<String, ArgumentType> arguments;
    protected final Map<String, Object> defaultValues;

    public TransformerFunction() {
        InputType[] annArr = (InputType[])this.getClass().getAnnotationsByType(InputType.class);
        this.inputType = annArr.length > 0 ? Arrays.stream(annArr).findFirst().get() : null;
        ArgumentType[] argArr = (ArgumentType[])this.getClass().getAnnotationsByType(ArgumentType.class);
        if (argArr.length > 0) {
            HashMap<String, ArgumentType> arguments = new HashMap<String, ArgumentType>();
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            Arrays.stream(argArr).forEachOrdered(arg -> {
                arguments.put(arg.value(), (ArgumentType)arg);
                if (arg.aliases().length > 0) {
                    Arrays.stream(arg.aliases()).forEach(alias -> arguments.put((String)alias, (ArgumentType)arg));
                }
                defaultValues.put(arg.value(), TransformerFunction.getDefaultValue(arg));
            });
            this.arguments = arguments;
            this.defaultValues = defaultValues;
        } else {
            this.arguments = Map.of();
            this.defaultValues = Map.of();
        }
    }

    private static Object getDefaultValue(ArgumentType a) {
        if (a == null || a.defaultIsNull()) {
            return null;
        }
        return switch (a.type()) {
            case ArgType.Boolean -> a.defaultBoolean();
            case ArgType.String -> a.defaultString();
            case ArgType.Enum -> a.defaultEnum();
            case ArgType.Integer -> a.defaultInteger();
            case ArgType.Long -> a.defaultLong();
            case ArgType.BigDecimal -> a.defaultBigDecimal();
            default -> null;
        };
    }

    public abstract Object apply(T var1);

    public ArgumentType getArgument(String name) {
        if (name == null) {
            return null;
        }
        return this.arguments.get(name);
    }

    public Map<String, ArgumentType> getArguments() {
        return this.arguments;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Object getDefaultValue(String name) {
        if (name == null) {
            return null;
        }
        return this.defaultValues.get(name);
    }
}

