/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest.runtime;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestFailedInitDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestSuiteDescriptor;
import co.helmethair.scalatest.descriptor.ScalatestTestDescriptor;
import co.helmethair.scalatest.reporter.JUnitReporter;
import co.helmethair.scalatest.runtime.StopperImpl;
import co.helmethair.scalatest.scala.OptionHelper;
import co.helmethair.scalatest.scala.ScalaConversions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.scalatest.Args;
import org.scalatest.ConfigMap;
import org.scalatest.ConfigMap$;
import org.scalatest.DynaTags;
import org.scalatest.Filter;
import org.scalatest.Filter$;
import org.scalatest.NameTransformer;
import org.scalatest.Reporter;
import org.scalatest.Resources;
import org.scalatest.Status;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.Event;
import org.scalatest.events.Ordinal;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.exceptions.TestFailedException;
import scala.Option;
import scala.collection.immutable.Map;
import scala.util.control.NonFatal$;

public class Executor {
    private static final ConfigMap emptyConfigMap = ConfigMap$.MODULE$.empty();
    private static final scala.collection.immutable.Set<String> chosenStyles = ScalaConversions.asScalaSet(Collections.emptySet()).toSet();
    private boolean skipAfterFail;

    public Executor() {
        this.skipAfterFail = false;
    }

    public Executor(boolean skipAfterFail) {
        this.skipAfterFail = skipAfterFail;
    }

    public void executeTest(TestDescriptor test, JUnitReporter reporter) {
        try {
            if (this.skipAfterFail && reporter.getSkipWithCause() != null) {
                reporter.getJunitListener().executionFinished(test, TestExecutionResult.aborted((Throwable)reporter.getSkipWithCause()));
                return;
            }
            if (test instanceof ScalatestSuiteDescriptor) {
                if (test.getChildren().isEmpty()) {
                    ((ScalatestSuiteDescriptor)test).getScalasuite().execute(null, emptyConfigMap, true, false, false, false, false);
                } else {
                    this.executeSuite(test, reporter);
                }
            } else if (test instanceof ScalatestTestDescriptor) {
                this.runScalatests(((ScalatestTestDescriptor)test).getContainingSuite(), Collections.singletonList((ScalatestTestDescriptor)test), reporter);
            } else if (test instanceof ScalatestEngineDescriptor) {
                this.executeSuite(test, reporter);
            } else if (test instanceof ScalatestFailedInitDescriptor) {
                reporter.getJunitListener().executionStarted(test);
                reporter.getJunitListener().executionFinished(test, TestExecutionResult.failed((Throwable)((ScalatestFailedInitDescriptor)test).getCause()));
            }
        }
        catch (Throwable e) {
            reporter.getJunitListener().executionFinished(test, TestExecutionResult.failed((Throwable)e));
        }
    }

    private void executeSuite(TestDescriptor test, JUnitReporter reporter) {
        reporter.getJunitListener().executionStarted(test);
        Set children = test.getChildren();
        List tests = children.stream().filter(c -> c instanceof ScalatestTestDescriptor).map(c -> (ScalatestTestDescriptor)c).collect(Collectors.toList());
        HashSet nonTests = new HashSet(children);
        nonTests.removeAll(tests);
        if (!tests.isEmpty()) {
            this.runScalatests((ScalatestSuiteDescriptor)test, tests.stream().sorted(Comparator.comparing(TestDescriptor::getDisplayName)).collect(Collectors.toList()), reporter);
        }
        nonTests.stream().sorted(Comparator.comparing(TestDescriptor::getDisplayName)).forEach(c -> this.executeTest((TestDescriptor)c, reporter));
        reporter.getJunitListener().executionFinished(test, TestExecutionResult.successful());
    }

    private void runScalatests(ScalatestSuiteDescriptor containingSuite, List<ScalatestTestDescriptor> tests, JUnitReporter reporter) {
        block5: {
            Suite scalasuite = containingSuite.getScalasuite();
            String SelectedTag = "Selected";
            scala.collection.immutable.Set<String> selectedSet = ScalaConversions.asScalaSet(Collections.singleton(SelectedTag));
            Set desiredTests = ScalaConversions.setAsJavaSet(scalasuite.testNames()).stream().filter(s -> tests.stream().anyMatch(t -> s.equals(t.getTestName()) || NameTransformer.decode((String)s).equals(t.getTestName()))).collect(Collectors.toSet());
            Map taggedTests = ScalaConversions.asScalaMap(desiredTests.stream().collect(Collectors.toMap(Function.identity(), x -> selectedSet)));
            Map dynaTagsMap = ScalaConversions.asScalaMap(Collections.singletonMap(scalasuite.suiteId(), taggedTests));
            Map emptyMap = ScalaConversions.asScalaMap(Collections.emptyMap());
            Filter filter = Filter$.MODULE$.apply(Option.apply(selectedSet), Filter$.MODULE$.apply$default$2(), false, new DynaTags(emptyMap, dynaTagsMap));
            Args args = this.createArgs(reporter, filter);
            try {
                Status status = scalasuite.run(Option.apply(null), args);
                status.waitUntilCompleted();
            }
            catch (Throwable e) {
                if (e instanceof InstantiationException || e instanceof IllegalAccessException) {
                    reporter.apply(this.suiteAborted(args.tracker().nextOrdinal(), e, Resources.cannotInstantiateSuite((Object)e.getMessage()), scalasuite));
                }
                if (e instanceof TestFailedException) {
                    reporter.apply(this.suiteAborted(args.tracker().nextOrdinal(), OptionHelper.getOrElse(((TestFailedException)e).cause(), e), Resources.bigProblems((Throwable)e), scalasuite));
                }
                if (e instanceof NoClassDefFoundError) {
                    reporter.apply(this.runAborted(args.tracker().nextOrdinal(), e, Resources.cannotLoadClass((Object)e.getMessage()), scalasuite));
                }
                reporter.apply(this.runAborted(args.tracker().nextOrdinal(), e, Resources.bigProblems((Throwable)e), scalasuite));
                if (NonFatal$.MODULE$.apply(e)) break block5;
                throw e;
            }
        }
    }

    private Event runAborted(Ordinal ordinal, Throwable e, String reason, Suite scalasuite) {
        return RunAborted$.MODULE$.apply(ordinal, reason, Option.apply((Object)e), Option.apply(null), Option.apply(null), Option.apply(null), Option.apply(null), Option.apply((Object)scalasuite), Thread.currentThread().getName(), new Date().getTime());
    }

    private Event suiteAborted(Ordinal ordinal, Throwable e, String message, Suite suite) {
        return SuiteAborted$.MODULE$.apply(ordinal, message, suite.suiteName(), suite.suiteId(), Option.apply((Object)suite.getClass().getName()), Option.apply((Object)e), Option.apply(null), Option.apply(null), Option.apply(null), Option.apply(null), Option.apply(null), Thread.currentThread().getName(), new Date().getTime());
    }

    private Args createArgs(JUnitReporter reporter, Filter filter) {
        Filter filterParam = filter == null ? Filter$.MODULE$.apply(Filter$.MODULE$.apply$default$1(), Filter$.MODULE$.apply$default$2(), Filter$.MODULE$.apply$default$3(), Filter$.MODULE$.apply$default$4()) : filter;
        return new Args((Reporter)reporter, (Stopper)new StopperImpl(), filterParam, emptyConfigMap, Option.apply(null), new Tracker(new Ordinal(0)), chosenStyles, false, Option.apply(null), Option.apply(null));
    }
}

