/*
 * Decompiled with CFR 0.152.
 */
package co.helmethair.scalatest;

import co.helmethair.scalatest.descriptor.ScalatestEngineDescriptor;
import co.helmethair.scalatest.reporter.JUnitReporter;
import co.helmethair.scalatest.runtime.Discovery;
import co.helmethair.scalatest.runtime.Executor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.scalatest.Suite;

public class ScalatestEngine
implements TestEngine {
    public static final String ID = "scalatest";
    public static final String PARAMETER_SKIP_AFTER_FAIL = "scalatest.junit.skip_after_fail";
    public static final boolean DEFAULT_SKIP_AFTER_FAIL = false;
    Discovery runtime = new Discovery();

    public String getId() {
        return ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        ScalatestEngineDescriptor engineDescriptor = new ScalatestEngineDescriptor(uniqueId, ID);
        List<Class<? extends Suite>> classes = this.discoverClassSelectors(discoveryRequest);
        return this.runtime.discover(engineDescriptor, classes, Thread.currentThread().getContextClassLoader());
    }

    public void execute(ExecutionRequest executionRequest) {
        Optional<ConfigurationParameters> params = Optional.ofNullable(executionRequest.getConfigurationParameters());
        boolean skipAfterFail = params.map(p -> p.getBoolean(PARAMETER_SKIP_AFTER_FAIL).orElse(false)).orElse(false);
        Executor executor = new Executor(skipAfterFail);
        JUnitReporter reporter = new JUnitReporter(executionRequest.getEngineExecutionListener(), executionRequest.getRootTestDescriptor());
        executor.executeTest(executionRequest.getRootTestDescriptor(), reporter);
    }

    private List<Class<? extends Suite>> discoverClassSelectors(EngineDiscoveryRequest dicoveryRequest) {
        return dicoveryRequest.getSelectorsByType(ClassSelector.class).stream().filter(c -> !c.getJavaClass().isAnonymousClass() && !c.getJavaClass().isLocalClass() && !c.getJavaClass().isSynthetic() && !Modifier.isAbstract(c.getJavaClass().getModifiers()) && Suite.class.isAssignableFrom(c.getJavaClass())).map(c -> c.getJavaClass()).collect(Collectors.toList());
    }
}

