/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.json.JSONException;
import org.json.JSONObject;

class PushHistory {
    private static final String TAG = "co.easimart.PushHistory";
    private final int maxHistoryLength;
    private final PriorityQueue<Entry> entries;
    private final HashSet<String> pushIds;
    private String lastTime;

    public PushHistory(int maxHistoryLength, JSONObject json) {
        this.maxHistoryLength = maxHistoryLength;
        this.entries = new PriorityQueue(maxHistoryLength + 1);
        this.pushIds = new HashSet(maxHistoryLength + 1);
        this.lastTime = null;
        if (json != null) {
            JSONObject jsonHistory = json.optJSONObject("seen");
            if (jsonHistory != null) {
                Iterator it = jsonHistory.keys();
                while (it.hasNext()) {
                    String pushId = (String)it.next();
                    String timestamp = jsonHistory.optString(pushId, null);
                    if (pushId == null || timestamp == null) continue;
                    this.tryInsertPush(pushId, timestamp);
                }
            }
            this.setLastReceivedTimestamp(json.optString("lastTime", null));
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        if (this.entries.size() > 0) {
            JSONObject history = new JSONObject();
            for (Entry e : this.entries) {
                history.put(e.pushId, (Object)e.timestamp);
            }
            json.put("seen", (Object)history);
        }
        json.putOpt("lastTime", (Object)this.lastTime);
        return json;
    }

    public String getLastReceivedTimestamp() {
        return this.lastTime;
    }

    public void setLastReceivedTimestamp(String lastTime) {
        this.lastTime = lastTime;
    }

    public boolean tryInsertPush(String pushId, String timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Can't insert null pushId or timestamp into history");
        }
        if (this.lastTime == null || timestamp.compareTo(this.lastTime) > 0) {
            this.lastTime = timestamp;
        }
        if (this.pushIds.contains(pushId)) {
            EasimartLog.e(TAG, "Ignored duplicate push " + pushId);
            return false;
        }
        this.entries.add(new Entry(pushId, timestamp));
        this.pushIds.add(pushId);
        while (this.entries.size() > this.maxHistoryLength) {
            Entry head = (Entry)this.entries.remove();
            this.pushIds.remove(head.pushId);
        }
        return true;
    }

    private static class Entry
    implements Comparable<Entry> {
        public String pushId;
        public String timestamp;

        public Entry(String pushId, String timestamp) {
            this.pushId = pushId;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Entry other) {
            return this.timestamp.compareTo(other.timestamp);
        }
    }
}

