/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import co.easimart.Easimart;
import co.easimart.EasimartBroadcastReceiver;
import co.easimart.EasimartLog;
import co.easimart.GcmBroadcastReceiver;
import co.easimart.PPNSUtil;
import co.easimart.PushService;
import co.easimart.PushType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ManifestInfo {
    private static final String TAG = "co.easimart.ManifestInfo";
    private static final int NUMBER_OF_PUSH_INTENTS = 3;
    private static final Object lock = new Object();
    private static long lastModified = -1L;
    static int versionCode = -1;
    static String versionName = null;
    private static int iconId = 0;
    private static String displayName = null;
    private static PushType pushType;

    ManifestInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified() {
        Object object = lock;
        synchronized (object) {
            if (lastModified == -1L) {
                File apkPath = new File(ManifestInfo.getContext().getApplicationInfo().sourceDir);
                lastModified = apkPath.lastModified();
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVersionCode() {
        Object object = lock;
        synchronized (object) {
            if (versionCode == -1) {
                try {
                    versionCode = ManifestInfo.getPackageManager().getPackageInfo((String)ManifestInfo.getContext().getPackageName(), (int)0).versionCode;
                }
                catch (PackageManager.NameNotFoundException e) {
                    EasimartLog.e(TAG, "Couldn't find info about own package", e);
                }
            }
        }
        return versionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionName() {
        Object object = lock;
        synchronized (object) {
            if (versionName == null) {
                try {
                    versionName = ManifestInfo.getPackageManager().getPackageInfo((String)ManifestInfo.getContext().getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    EasimartLog.e(TAG, "Couldn't find info about own package", e);
                }
            }
        }
        return versionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDisplayName(Context context) {
        Object object = lock;
        synchronized (object) {
            if (displayName == null) {
                ApplicationInfo appInfo = context.getApplicationInfo();
                displayName = context.getPackageManager().getApplicationLabel(appInfo).toString();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIconId() {
        Object object = lock;
        synchronized (object) {
            if (iconId == 0) {
                iconId = ManifestInfo.getContext().getApplicationInfo().icon;
            }
        }
        return iconId;
    }

    static boolean hasIntentReceiver(String action) {
        return !ManifestInfo.getIntentReceivers(action).isEmpty();
    }

    static List<ResolveInfo> getIntentReceivers(String ... actions) {
        Context context = ManifestInfo.getContext();
        String packageName = context.getPackageName();
        ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>();
        for (String action : actions) {
            list.addAll(context.getPackageManager().queryBroadcastReceivers(new Intent(action), 32));
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String receiverPackageName = ((ResolveInfo)list.get((int)i)).activityInfo.packageName;
            if (receiverPackageName.equals(packageName)) continue;
            list.remove(i);
        }
        return list;
    }

    private static boolean usesPushBroadcastReceivers() {
        int intentsRegistered = 0;
        if (ManifestInfo.hasIntentReceiver("co.easimart.push.intent.RECEIVE")) {
            ++intentsRegistered;
        }
        if (ManifestInfo.hasIntentReceiver("co.easimart.push.intent.OPEN")) {
            ++intentsRegistered;
        }
        if (ManifestInfo.hasIntentReceiver("co.easimart.push.intent.DELETE")) {
            ++intentsRegistered;
        }
        if (intentsRegistered != 0 && intentsRegistered != 3) {
            throw new SecurityException("The Easimart Push BroadcastReceiver must implement a filter for all of co.easimart.push.intent.RECEIVE, co.easimart.push.intent.OPEN, and co.easimart.push.intent.DELETE");
        }
        return intentsRegistered == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPushType(PushType newPushType) {
        Object object = lock;
        synchronized (object) {
            pushType = newPushType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushType getPushType() {
        Object object = lock;
        synchronized (object) {
            if (pushType == null) {
                boolean hasRequiredPpnsDeclarations;
                boolean isGooglePlayServicesAvailable = ManifestInfo.isGooglePlayServicesAvailable();
                boolean isPPNSAvailable = PPNSUtil.isPPNSAvailable();
                boolean hasAnyGcmSpecificDeclaration = ManifestInfo.hasAnyGcmSpecificDeclaration();
                ManifestCheckResult gcmSupportLevel = ManifestInfo.gcmSupportLevel();
                ManifestCheckResult ppnsSupportLevel = ManifestInfo.ppnsSupportLevel();
                boolean hasPushBroadcastReceiver = ManifestInfo.usesPushBroadcastReceivers();
                boolean hasRequiredGcmDeclarations = gcmSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
                boolean bl = hasRequiredPpnsDeclarations = ppnsSupportLevel != ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
                if (hasPushBroadcastReceiver && isGooglePlayServicesAvailable && hasRequiredGcmDeclarations) {
                    pushType = PushType.GCM;
                } else if (hasPushBroadcastReceiver && isPPNSAvailable && hasRequiredPpnsDeclarations && (!hasAnyGcmSpecificDeclaration || !isGooglePlayServicesAvailable)) {
                    pushType = PushType.PPNS;
                    if (isGooglePlayServicesAvailable) {
                        Log.w((String)TAG, (String)("Using PPNS for push even though Google Play Services is available. Please " + ManifestInfo.getGcmManifestMessage()));
                    }
                } else {
                    pushType = PushType.NONE;
                    if (hasAnyGcmSpecificDeclaration) {
                        if (!hasPushBroadcastReceiver) {
                            EasimartLog.e(TAG, "Push is currently disabled. This is probably because you migrated from an older version of Easimart. This version of Easimart requires your app to have a BroadcastReceiver that handles co.easimart.push.intent.RECEIVE, co.easimart.push.intent.OPEN, and co.easimart.push.intent.DELETE. You can do this by adding these lines to your AndroidManifest.xml:\n\n <receiver android:name=\"co.easimart.EasimartPushBroadcastReceiver\"\n   android:exported=false>\n  <intent-filter>\n     <action android:name=\"co.easimart.push.intent.RECEIVE\" />\n     <action android:name=\"co.easimart.push.intent.OPEN\" />\n     <action android:name=\"co.easimart.push.intent.DELETE\" />\n   </intent-filter>\n </receiver>");
                        }
                        if (!isGooglePlayServicesAvailable) {
                            EasimartLog.e(TAG, "Cannot use GCM for push on this device because Google Play Services is not available. Install Google Play Services from the Play Store.");
                        }
                        if (!hasRequiredGcmDeclarations) {
                            EasimartLog.e(TAG, "Cannot use GCM for push because the app manifest is missing some required declarations. Please " + ManifestInfo.getGcmManifestMessage());
                        }
                    }
                }
                EasimartLog.v(TAG, "Using " + (Object)((Object)pushType) + " for push.");
                if (Easimart.getLogLevel() <= 5) {
                    if (pushType == PushType.GCM && gcmSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        EasimartLog.w(TAG, "Using GCM for Easimart Push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getGcmManifestMessage());
                    } else if (pushType == PushType.PPNS && ppnsSupportLevel == ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS) {
                        EasimartLog.w(TAG, "Using PPNS for push, but the app manifest is missing some optional declarations that should be added for maximum reliability. Please " + ManifestInfo.getPpnsManifestMessage());
                    }
                }
            }
        }
        return pushType;
    }

    public static String getNonePushTypeLogMessage() {
        return "Push is not configured for this app because the app manifest is missing required declarations. Please add the following declarations to your app manifest to use GCM for push: " + ManifestInfo.getGcmManifestMessage();
    }

    private static Context getContext() {
        return Easimart.getApplicationContext();
    }

    private static PackageManager getPackageManager() {
        return ManifestInfo.getContext().getPackageManager();
    }

    private static ApplicationInfo getApplicationInfo(Context context, int flags) {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static Bundle getApplicationMetadata(Context context) {
        ApplicationInfo info = ManifestInfo.getApplicationInfo(context, 128);
        if (info != null) {
            return info.metaData;
        }
        return null;
    }

    private static PackageInfo getPackageInfo(String name) {
        PackageInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getPackageInfo(name, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ServiceInfo getServiceInfo(Class<? extends Service> clazz) {
        ServiceInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getServiceInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static ActivityInfo getReceiverInfo(Class<? extends BroadcastReceiver> clazz) {
        ActivityInfo info = null;
        try {
            info = ManifestInfo.getPackageManager().getReceiverInfo(new ComponentName(ManifestInfo.getContext(), clazz), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private static boolean hasRequestedPermissions(Context context, String ... permissions) {
        String packageName = context.getPackageName();
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(packageName, 4096);
            return Arrays.asList(pi.requestedPermissions).containsAll(Arrays.asList(permissions));
        }
        catch (PackageManager.NameNotFoundException e) {
            EasimartLog.e(TAG, "Couldn't find info about own package", e);
            return false;
        }
    }

    private static boolean hasGrantedPermissions(Context context, String ... permissions) {
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        for (String permission2 : permissions) {
            if (packageManager.checkPermission(permission2, packageName) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean checkResolveInfo(Class<? extends BroadcastReceiver> clazz, List<ResolveInfo> infoList) {
        for (ResolveInfo info : infoList) {
            if (info.activityInfo == null || !clazz.getCanonicalName().equals(info.activityInfo.name)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkReceiver(Class<? extends BroadcastReceiver> clazz, String permission2, Intent[] intents) {
        ActivityInfo receiver = ManifestInfo.getReceiverInfo(clazz);
        if (receiver == null) {
            return false;
        }
        if (permission2 != null && !permission2.equals(receiver.permission)) {
            return false;
        }
        for (Intent intent : intents) {
            List receivers = ManifestInfo.getPackageManager().queryBroadcastReceivers(intent, 0);
            if (receivers.isEmpty()) {
                return false;
            }
            if (ManifestInfo.checkResolveInfo(clazz, receivers)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyGcmSpecificDeclaration() {
        Context context = ManifestInfo.getContext();
        return ManifestInfo.hasRequestedPermissions(context, "com.google.android.c2dm.permission.RECEIVE") || ManifestInfo.hasRequestedPermissions(context, context.getPackageName() + ".permission.C2D_MESSAGE") || ManifestInfo.getReceiverInfo(GcmBroadcastReceiver.class) != null;
    }

    private static boolean isGooglePlayServicesAvailable() {
        return Build.VERSION.SDK_INT >= 8 && ManifestInfo.getPackageInfo("com.google.android.gsf") != null;
    }

    private static ManifestCheckResult gcmSupportLevel() {
        Context context = ManifestInfo.getContext();
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] requiredPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK", "com.google.android.c2dm.permission.RECEIVE", context.getPackageName() + ".permission.C2D_MESSAGE"};
        if (!ManifestInfo.hasRequestedPermissions(context, requiredPermissions)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String packageName = context.getPackageName();
        String rcvrPermission = "com.google.android.c2dm.permission.SEND";
        Intent[] intents = new Intent[]{new Intent("com.google.android.c2dm.intent.RECEIVE").setPackage(packageName).addCategory(packageName), new Intent("com.google.android.c2dm.intent.REGISTRATION").setPackage(packageName).addCategory(packageName)};
        if (!ManifestInfo.checkReceiver(GcmBroadcastReceiver.class, rcvrPermission, intents)) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.VIBRATE"};
        if (!ManifestInfo.hasGrantedPermissions(context, optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static ManifestCheckResult ppnsSupportLevel() {
        Context context = ManifestInfo.getContext();
        if (ManifestInfo.getServiceInfo(PushService.class) == null) {
            return ManifestCheckResult.MISSING_REQUIRED_DECLARATIONS;
        }
        String[] optionalPermissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.RECEIVE_BOOT_COMPLETED"};
        if (!ManifestInfo.hasGrantedPermissions(context, optionalPermissions)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        String packageName = context.getPackageName();
        Intent[] intents = new Intent[]{new Intent("android.intent.action.BOOT_COMPLETED").setPackage(packageName), new Intent("android.intent.action.USER_PRESENT").setPackage(packageName)};
        if (!ManifestInfo.checkReceiver(EasimartBroadcastReceiver.class, null, intents)) {
            return ManifestCheckResult.MISSING_OPTIONAL_DECLARATIONS;
        }
        return ManifestCheckResult.HAS_ALL_DECLARATIONS;
    }

    private static String getGcmManifestMessage() {
        String packageName = ManifestInfo.getContext().getPackageName();
        String gcmPackagePermission = packageName + ".permission.C2D_MESSAGE";
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"android.permission.GET_ACCOUNTS\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<permission android:name=\"" + gcmPackagePermission + "\" " + "android:protectionLevel=\"signature\" />\n" + "<uses-permission android:name=\"" + gcmPackagePermission + "\" />\n" + "\n" + "Also, please make sure that these services and broadcast receivers are declared as " + "children of the <application> element:\n" + "\n" + "<service android:name=\"co.easimart.PushService\" />\n" + "<receiver android:name=\"co.easimart.GcmBroadcastReceiver\" " + "android:permission=\"com.google.android.c2dm.permission.SEND\">\n" + "  <intent-filter>\n" + "    <action android:name=\"com.google.android.c2dm.intent.RECEIVE\" />\n" + "    <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\" />\n" + "    <category android:name=\"" + packageName + "\" />\n" + "  </intent-filter>\n" + "</receiver>\n" + "<receiver android:name=\"co.easimart.EasimartPushBroadcastReceiver\"" + " android:exported=false>\n" + "  <intent-filter>\n" + "    <action android:name=\"co.easimart.push.intent.RECEIVE\" />\n" + "    <action android:name=\"co.easimart.push.intent.OPEN\" />\n" + "    <action android:name=\"co.easimart.push.intent.DELETE\" />\n" + "  </intent-filter>\n" + "</receiver>";
    }

    private static String getPpnsManifestMessage() {
        return "make sure that these permissions are declared as children of the root <manifest> element:\n\n<uses-permission android:name=\"android.permission.INTERNET\" />\n<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\" />\n<uses-permission android:name=\"android.permission.RECEIVE_BOOT_COMPLETED\" />\n<uses-permission android:name=\"android.permission.VIBRATE\" />\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n\nAlso, please make sure that these services and broadcast receivers are declared as children of the <application> element:\n\n<service android:name=\"co.easimart.PushService\" />\n<receiver android:name=\"co.easimart.EasimartBroadcastReceiver\">\n  <intent-filter>\n    <action android:name=\"android.intent.action.BOOT_COMPLETED\" />\n    <action android:name=\"android.intent.action.USER_PRESENT\" />\n  </intent-filter>\n</receiver>\n<receiver android:name=\"co.easimart.EasimartPushBroadcastReceiver\" android:exported=false>\n  <intent-filter>\n    <action android:name=\"co.easimart.push.intent.RECEIVE\" />\n    <action android:name=\"co.easimart.push.intent.OPEN\" />\n    <action android:name=\"co.easimart.push.intent.DELETE\" />\n  </intent-filter>\n</receiver>";
    }

    static enum ManifestCheckResult {
        HAS_ALL_DECLARATIONS,
        MISSING_OPTIONAL_DECLARATIONS,
        MISSING_REQUIRED_DECLARATIONS;

    }
}

