/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import android.os.PowerManager;
import co.easimart.EasimartLog;

class EasimartWakeLock {
    private static final String TAG = "co.easimart.EasimartWakeLock";
    private static volatile boolean hasWakeLockPermission = true;
    private final PowerManager.WakeLock wakeLock;

    public static EasimartWakeLock acquireNewWakeLock(Context context, int type, String reason, long timeout) {
        PowerManager.WakeLock wl = null;
        if (hasWakeLockPermission) {
            try {
                PowerManager pm = (PowerManager)context.getApplicationContext().getSystemService("power");
                if (pm != null && (wl = pm.newWakeLock(type, reason)) != null) {
                    wl.setReferenceCounted(false);
                    if (timeout == 0L) {
                        wl.acquire();
                    } else {
                        wl.acquire(timeout);
                    }
                }
            }
            catch (SecurityException e) {
                EasimartLog.e(TAG, "Failed to acquire a PowerManager.WakeLock. This isnecessary for reliable handling of pushes. Please add this to your Manifest.xml: <uses-permission android:name=\"android.permission.WAKE_LOCK\" /> ");
                hasWakeLockPermission = false;
                wl = null;
            }
        }
        return new EasimartWakeLock(wl);
    }

    private EasimartWakeLock(PowerManager.WakeLock wakeLock) {
        this.wakeLock = wakeLock;
    }

    public void release() {
        if (this.wakeLock != null) {
            this.wakeLock.release();
        }
    }
}

