/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartACL;
import co.easimart.EasimartObject;
import co.easimart.EasimartUser;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class EasimartTraverser {
    private boolean traverseEasimartObjects = false;
    private boolean yieldRoot = false;

    protected abstract boolean visit(Object var1);

    private void traverseInternal(Object root, boolean yieldRoot, IdentityHashMap<Object, Object> seen) {
        EasimartACL acl;
        EasimartUser user;
        if (root == null || seen.containsKey(root)) {
            return;
        }
        if (yieldRoot && !this.visit(root)) {
            return;
        }
        seen.put(root, root);
        if (root instanceof JSONObject) {
            JSONObject json = (JSONObject)root;
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    this.traverseInternal(json.get(key), true, seen);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (root instanceof JSONArray) {
            JSONArray array = (JSONArray)root;
            for (int i = 0; i < array.length(); ++i) {
                try {
                    this.traverseInternal(array.get(i), true, seen);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (root instanceof Map) {
            Map map = (Map)root;
            for (Object value : map.values()) {
                this.traverseInternal(value, true, seen);
            }
        } else if (root instanceof List) {
            List list = (List)root;
            for (Object value : list) {
                this.traverseInternal(value, true, seen);
            }
        } else if (root instanceof EasimartObject) {
            if (this.traverseEasimartObjects) {
                EasimartObject object = (EasimartObject)root;
                for (String key : object.keySet()) {
                    this.traverseInternal(object.get(key), true, seen);
                }
            }
        } else if (root instanceof EasimartACL && (user = (acl = (EasimartACL)root).getUnresolvedUser()) != null && user.isCurrentUser()) {
            this.traverseInternal(user, true, seen);
        }
    }

    public EasimartTraverser setTraverseEasimartObjects(boolean newValue) {
        this.traverseEasimartObjects = newValue;
        return this;
    }

    public EasimartTraverser setYieldRoot(boolean newValue) {
        this.yieldRoot = newValue;
        return this;
    }

    public void traverse(Object root) {
        IdentityHashMap<Object, Object> seen = new IdentityHashMap<Object, Object>();
        this.traverseInternal(root, this.yieldRoot, seen);
    }
}

