/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.AggregateException;
import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCallback1;
import co.easimart.EasimartCallback2;
import co.easimart.EasimartException;
import co.easimart.EasimartExecutors;
import java.util.concurrent.CancellationException;

class EasimartTaskUtils {
    EasimartTaskUtils() {
    }

    static <T> T wait(Task<T> task) throws EasimartException {
        try {
            task.waitForCompletion();
            if (task.isFaulted()) {
                Exception error = task.getError();
                if (error instanceof EasimartException) {
                    throw (EasimartException)error;
                }
                if (error instanceof AggregateException) {
                    throw new EasimartException(error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
            if (task.isCancelled()) {
                throw new RuntimeException(new CancellationException());
            }
            return (T)task.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static Task<Void> callbackOnMainThreadAsync(Task<Void> task, EasimartCallback1<EasimartException> callback) {
        return EasimartTaskUtils.callbackOnMainThreadAsync(task, callback, false);
    }

    static Task<Void> callbackOnMainThreadAsync(Task<Void> task, final EasimartCallback1<EasimartException> callback, boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        return EasimartTaskUtils.callbackOnMainThreadAsync(task, new EasimartCallback2<Void, EasimartException>(){

            @Override
            public void done(Void aVoid, EasimartException e) {
                callback.done(e);
            }
        }, reportCancellation);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, EasimartCallback2<T, EasimartException> callback) {
        return EasimartTaskUtils.callbackOnMainThreadAsync(task, callback, false);
    }

    static <T> Task<T> callbackOnMainThreadAsync(Task<T> task, final EasimartCallback2<T, EasimartException> callback, final boolean reportCancellation) {
        if (callback == null) {
            return task;
        }
        final Task.TaskCompletionSource tcs = Task.create();
        task.continueWith(new Continuation<T, Void>(){

            public Void then(final Task<T> task) throws Exception {
                if (task.isCancelled() && !reportCancellation) {
                    tcs.setCancelled();
                    return null;
                }
                EasimartExecutors.main().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Exception error = task.getError();
                            if (error != null && !(error instanceof EasimartException)) {
                                error = new EasimartException(error);
                            }
                            callback.done(task.getResult(), (EasimartException)error);
                        }
                        finally {
                            if (task.isCancelled()) {
                                tcs.setCancelled();
                            } else if (task.isFaulted()) {
                                tcs.setError(task.getError());
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                    }
                });
                return null;
            }
        });
        return tcs.getTask();
    }
}

