/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartFieldOperations;
import co.easimart.EasimartObject;
import co.easimart.EasimartSetOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartRemoveOperation
implements EasimartFieldOperation {
    protected final HashSet<Object> objects = new HashSet();

    public EasimartRemoveOperation(Collection<?> coll) {
        this.objects.addAll(coll);
    }

    public JSONObject encode(EasimartEncoder objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"Remove");
        output.put("objects", objectEncoder.encode(new ArrayList<Object>(this.objects)));
        return output;
    }

    @Override
    public EasimartFieldOperation mergeWithPrevious(EasimartFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof EasimartDeleteOperation) {
            return new EasimartSetOperation(this.objects);
        }
        if (previous instanceof EasimartSetOperation) {
            Object value = ((EasimartSetOperation)previous).getValue();
            if (value instanceof JSONArray || value instanceof List) {
                return new EasimartSetOperation(this.apply(value, null));
            }
            throw new IllegalArgumentException("You can only add an item to a List or JSONArray.");
        }
        if (previous instanceof EasimartRemoveOperation) {
            HashSet<Object> result = new HashSet<Object>(((EasimartRemoveOperation)previous).objects);
            result.addAll(this.objects);
            return new EasimartRemoveOperation(result);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        if (oldValue == null) {
            return new ArrayList();
        }
        if (oldValue instanceof JSONArray) {
            ArrayList<Object> old = EasimartFieldOperations.jsonArrayAsArrayList((JSONArray)oldValue);
            ArrayList newValue = (ArrayList)this.apply(old, key);
            return new JSONArray((Collection)newValue);
        }
        if (oldValue instanceof List) {
            ArrayList result = new ArrayList((List)oldValue);
            result.removeAll(this.objects);
            ArrayList<Object> objectsToBeRemoved = new ArrayList<Object>(this.objects);
            objectsToBeRemoved.removeAll(result);
            HashSet<String> objectIds = new HashSet<String>();
            for (Object obj : objectsToBeRemoved) {
                if (!(obj instanceof EasimartObject)) continue;
                objectIds.add(((EasimartObject)obj).getObjectId());
            }
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                Object obj;
                obj = resultIterator.next();
                if (!(obj instanceof EasimartObject) || !objectIds.contains(((EasimartObject)obj).getObjectId())) continue;
                resultIterator.remove();
            }
            return result;
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }
}

