/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartDecoder;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRelationOperation;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EasimartRelation<T extends EasimartObject> {
    private final Object mutex = new Object();
    private WeakReference<EasimartObject> parent;
    private String parentObjectId;
    private String parentClassName;
    private String key;
    private String targetClass;
    private Set<EasimartObject> knownObjects = new HashSet<EasimartObject>();

    EasimartRelation(EasimartObject parent, String key) {
        this.parent = new WeakReference<EasimartObject>(parent);
        this.parentObjectId = parent.getObjectId();
        this.parentClassName = parent.getClassName();
        this.key = key;
        this.targetClass = null;
    }

    EasimartRelation(String targetClass) {
        this.parent = null;
        this.parentObjectId = null;
        this.parentClassName = null;
        this.key = null;
        this.targetClass = targetClass;
    }

    EasimartRelation(JSONObject jsonObject, EasimartDecoder decoder) {
        this.parent = null;
        this.parentObjectId = null;
        this.parentClassName = null;
        this.key = null;
        this.targetClass = jsonObject.optString("className", null);
        JSONArray objectsArray = jsonObject.optJSONArray("objects");
        if (objectsArray != null) {
            for (int i = 0; i < objectsArray.length(); ++i) {
                this.knownObjects.add((EasimartObject)decoder.decode(objectsArray.optJSONObject(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureParentAndKey(EasimartObject someParent, String someKey) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.parent == null) {
                this.parent = new WeakReference<EasimartObject>(someParent);
                this.parentObjectId = someParent.getObjectId();
                this.parentClassName = someParent.getClassName();
            }
            if (this.key == null) {
                this.key = someKey;
            }
            if (this.parent.get() != someParent) {
                throw new IllegalStateException("Internal error. One EasimartRelation retrieved from two different EasimartObjects.");
            }
            if (!this.key.equals(someKey)) {
                throw new IllegalStateException("Internal error. One EasimartRelation retrieved from two different keys.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            EasimartRelationOperation<T> operation = new EasimartRelationOperation<T>(Collections.singleton(object), null);
            this.targetClass = operation.getTargetClass();
            this.getParent().performOperation(this.key, operation);
            this.knownObjects.add((EasimartObject)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            EasimartRelationOperation<T> operation = new EasimartRelationOperation<T>(null, Collections.singleton(object));
            this.targetClass = operation.getTargetClass();
            this.getParent().performOperation(this.key, operation);
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasimartQuery<T> getQuery() {
        Object object = this.mutex;
        synchronized (object) {
            EasimartQuery.State.Builder builder = this.targetClass == null ? new EasimartQuery.State.Builder(this.parentClassName).redirectClassNameForKey(this.key) : new EasimartQuery.State.Builder(this.targetClass);
            builder.whereRelatedTo(this.getParent(), this.key);
            return new EasimartQuery(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject encodeToJSON(EasimartEncoder objectEncoder) throws JSONException {
        Object object = this.mutex;
        synchronized (object) {
            JSONObject relation = new JSONObject();
            relation.put("__type", (Object)"Relation");
            relation.put("className", (Object)this.targetClass);
            JSONArray knownObjectsArray = new JSONArray();
            for (EasimartObject knownObject : this.knownObjects) {
                try {
                    knownObjectsArray.put((Object)objectEncoder.encodeRelatedObject(knownObject));
                }
                catch (Exception exception) {}
            }
            relation.put("objects", (Object)knownObjectsArray);
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTargetClass() {
        Object object = this.mutex;
        synchronized (object) {
            return this.targetClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTargetClass(String className) {
        Object object = this.mutex;
        synchronized (object) {
            this.targetClass = className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addKnownObject(EasimartObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKnownObject(EasimartObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.knownObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasKnownObject(EasimartObject object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.knownObjects.contains(object);
        }
    }

    EasimartObject getParent() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.get() == null) {
            return EasimartObject.createWithoutData(this.parentClassName, this.parentObjectId);
        }
        return (EasimartObject)this.parent.get();
    }

    String getKey() {
        return this.key;
    }

    Set<EasimartObject> getKnownObjects() {
        return this.knownObjects;
    }
}

