/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.net.Uri;
import co.easimart.EasimartObject;
import co.easimart.EasimartRESTCommand;
import co.easimart.http.EasimartHttpRequest;
import org.json.JSONObject;

class EasimartRESTObjectCommand
extends EasimartRESTCommand {
    public EasimartRESTObjectCommand(String httpPath, EasimartHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    public static EasimartRESTObjectCommand getObjectCommand(String objectId, String className, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new EasimartRESTObjectCommand(httpPath, EasimartHttpRequest.Method.GET, null, sessionToken);
    }

    public static EasimartRESTObjectCommand saveObjectCommand(EasimartObject.State state, JSONObject operations, String sessionToken) {
        if (state.objectId() == null) {
            return EasimartRESTObjectCommand.createObjectCommand(state.className(), operations, sessionToken);
        }
        return EasimartRESTObjectCommand.updateObjectCommand(state.objectId(), state.className(), operations, sessionToken);
    }

    private static EasimartRESTObjectCommand createObjectCommand(String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)className));
        return new EasimartRESTObjectCommand(httpPath, EasimartHttpRequest.Method.POST, changes, sessionToken);
    }

    private static EasimartRESTObjectCommand updateObjectCommand(String objectId, String className, JSONObject changes, String sessionToken) {
        String httpPath = String.format("classes/%s/%s", Uri.encode((String)className), Uri.encode((String)objectId));
        return new EasimartRESTObjectCommand(httpPath, EasimartHttpRequest.Method.PUT, changes, sessionToken);
    }

    public static EasimartRESTObjectCommand deleteObjectCommand(EasimartObject.State state, String sessionToken) {
        String httpPath = String.format("classes/%s", Uri.encode((String)state.className()));
        String objectId = state.objectId();
        if (objectId != null) {
            httpPath = httpPath + String.format("/%s", Uri.encode((String)objectId));
        }
        return new EasimartRESTObjectCommand(httpPath, EasimartHttpRequest.Method.DELETE, null, sessionToken);
    }
}

