/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartPush;
import co.easimart.EasimartRESTCommand;
import co.easimart.EasimartRESTPushCommand;

class EasimartPushController {
    static final String DEVICE_TYPE_IOS = "ios";
    static final String DEVICE_TYPE_ANDROID = "android";
    private final EasimartHttpClient restClient;

    public EasimartPushController(EasimartHttpClient restClient) {
        this.restClient = restClient;
    }

    public Task<Void> sendInBackground(EasimartPush.State state, String sessionToken) {
        return this.buildRESTSendPushCommand(state, sessionToken).executeAsync(this.restClient).makeVoid();
    }

    EasimartRESTCommand buildRESTSendPushCommand(EasimartPush.State state, String sessionToken) {
        String deviceType = null;
        if (state.queryState() == null) {
            boolean willPushToIOS;
            boolean willPushToAndroid = state.pushToAndroid() != null && state.pushToAndroid() != false;
            boolean bl = willPushToIOS = state.pushToIOS() != null && state.pushToIOS() != false;
            if (!willPushToIOS || !willPushToAndroid) {
                if (willPushToIOS) {
                    deviceType = DEVICE_TYPE_IOS;
                } else if (willPushToAndroid) {
                    deviceType = DEVICE_TYPE_ANDROID;
                }
            }
        }
        return EasimartRESTPushCommand.sendPushCommand(state.queryState(), state.channelSet(), deviceType, state.expirationTime(), state.expirationTimeInterval(), state.data(), sessionToken);
    }
}

