/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartCurrentInstallationController;
import co.easimart.EasimartInstallation;
import co.easimart.EasimartLog;
import co.easimart.ManifestInfo;
import co.easimart.PushType;
import java.util.Collections;
import java.util.List;

class EasimartPushChannelsController {
    private static final String TAG = "co.easimart.EasimartPushChannelsController";
    private static boolean loggedManifestError = false;

    EasimartPushChannelsController() {
    }

    private static EasimartCurrentInstallationController getCurrentInstallationController() {
        return EasimartCorePlugins.getInstance().getCurrentInstallationController();
    }

    public Task<Void> subscribeInBackground(final String channel) {
        EasimartPushChannelsController.checkManifestAndLogErrorIfNecessary();
        if (channel == null) {
            throw new IllegalArgumentException("Can't subscribe to null channel.");
        }
        return EasimartPushChannelsController.getCurrentInstallationController().getAsync().onSuccessTask((Continuation)new Continuation<EasimartInstallation, Task<Void>>(){

            public Task<Void> then(Task<EasimartInstallation> task) throws Exception {
                EasimartInstallation installation = (EasimartInstallation)task.getResult();
                List channels = installation.getList("channels");
                if (channels == null || installation.isDirty("channels") || !channels.contains(channel)) {
                    installation.addUnique("channels", channel);
                    return installation.saveInBackground();
                }
                return Task.forResult(null);
            }
        });
    }

    public Task<Void> unsubscribeInBackground(final String channel) {
        EasimartPushChannelsController.checkManifestAndLogErrorIfNecessary();
        if (channel == null) {
            throw new IllegalArgumentException("Can't unsubscribe from null channel.");
        }
        return EasimartPushChannelsController.getCurrentInstallationController().getAsync().onSuccessTask((Continuation)new Continuation<EasimartInstallation, Task<Void>>(){

            public Task<Void> then(Task<EasimartInstallation> task) throws Exception {
                EasimartInstallation installation = (EasimartInstallation)task.getResult();
                List channels = installation.getList("channels");
                if (channels != null && channels.contains(channel)) {
                    installation.removeAll("channels", Collections.singletonList(channel));
                    return installation.saveInBackground();
                }
                return Task.forResult(null);
            }
        });
    }

    private static void checkManifestAndLogErrorIfNecessary() {
        if (!loggedManifestError && ManifestInfo.getPushType() == PushType.NONE) {
            loggedManifestError = true;
            EasimartLog.e(TAG, "Tried to subscribe or unsubscribe from a channel, but push is not enabled correctly. " + ManifestInfo.getNonePushTypeLogMessage());
        }
    }
}

