/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import co.easimart.EasimartFileUtils;
import co.easimart.EasimartLog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartKeyValueCache {
    private static final String TAG = "EasimartKeyValueCache";
    private static final String DIR_NAME = "EasimartKeyValueCache";
    static final int DEFAULT_MAX_KEY_VALUE_CACHE_BYTES = 0x200000;
    static final int DEFAULT_MAX_KEY_VALUE_CACHE_FILES = 1000;
    private static final Object MUTEX_IO = new Object();
    static int maxKeyValueCacheBytes = 0x200000;
    static int maxKeyValueCacheFiles = 1000;
    private static File directory;

    EasimartKeyValueCache() {
    }

    static void initialize(Context context) {
        EasimartKeyValueCache.initialize(new File(context.getCacheDir(), "EasimartKeyValueCache"));
    }

    static void initialize(File path) {
        if (!path.isDirectory() && !path.mkdir()) {
            throw new RuntimeException("Could not create EasimartKeyValueCache directory");
        }
        directory = path;
    }

    private static File getKeyValueCacheDir() {
        if (directory == null || !directory.exists()) {
            directory.mkdir();
        }
        return directory;
    }

    static int size() {
        File[] files = EasimartKeyValueCache.getKeyValueCacheDir().listFiles();
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    private static File getKeyValueCacheFile(String key) {
        final String suffix = '.' + key;
        File[] matches = EasimartKeyValueCache.getKeyValueCacheDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(suffix);
            }
        });
        return matches == null || matches.length == 0 ? null : matches[0];
    }

    private static long getKeyValueCacheAge(File cacheFile) {
        String name = cacheFile.getName();
        try {
            return Long.parseLong(name.substring(0, name.indexOf(46)));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static File createKeyValueCacheFile(String key) {
        String filename = String.valueOf(new Date().getTime()) + '.' + key;
        return new File(EasimartKeyValueCache.getKeyValueCacheDir(), filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearKeyValueCacheDir() {
        Object object = MUTEX_IO;
        synchronized (object) {
            File dir = EasimartKeyValueCache.getKeyValueCacheDir();
            if (dir == null) {
                return;
            }
            File[] entries = dir.listFiles();
            if (entries == null) {
                return;
            }
            for (File entry : entries) {
                entry.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveToKeyValueCache(String key, String value) {
        Object object = MUTEX_IO;
        synchronized (object) {
            File prior = EasimartKeyValueCache.getKeyValueCacheFile(key);
            if (prior != null) {
                prior.delete();
            }
            File f = EasimartKeyValueCache.createKeyValueCacheFile(key);
            try {
                EasimartFileUtils.writeByteArrayToFile(f, value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File[] files = EasimartKeyValueCache.getKeyValueCacheDir().listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            int numFiles = files.length;
            int numBytes = 0;
            for (File file : files) {
                numBytes = (int)((long)numBytes + file.length());
            }
            if (numFiles <= maxKeyValueCacheFiles && numBytes <= maxKeyValueCacheBytes) {
                return;
            }
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    int dateCompare = Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                    if (dateCompare != 0) {
                        return dateCompare;
                    }
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File file : files) {
                numBytes = (int)((long)numBytes - file.length());
                file.delete();
                if (--numFiles <= maxKeyValueCacheFiles && numBytes <= maxKeyValueCacheBytes) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearFromKeyValueCache(String key) {
        Object object = MUTEX_IO;
        synchronized (object) {
            File file = EasimartKeyValueCache.getKeyValueCacheFile(key);
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String loadFromKeyValueCache(String key, long maxAgeMilliseconds) {
        Object object = MUTEX_IO;
        synchronized (object) {
            File file = EasimartKeyValueCache.getKeyValueCacheFile(key);
            if (file == null) {
                return null;
            }
            Date now = new Date();
            long oldestAcceptableAge = Math.max(0L, now.getTime() - maxAgeMilliseconds);
            if (EasimartKeyValueCache.getKeyValueCacheAge(file) < oldestAcceptableAge) {
                return null;
            }
            file.setLastModified(now.getTime());
            try {
                RandomAccessFile f = new RandomAccessFile(file, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                f.close();
                return new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                EasimartLog.e("EasimartKeyValueCache", "error reading from cache", e);
                return null;
            }
        }
    }

    static JSONObject jsonFromKeyValueCache(String key, long maxAgeMilliseconds) {
        String raw = EasimartKeyValueCache.loadFromKeyValueCache(key, maxAgeMilliseconds);
        if (raw == null) {
            return null;
        }
        try {
            return new JSONObject(raw);
        }
        catch (JSONException e) {
            EasimartLog.e("EasimartKeyValueCache", "corrupted cache for " + key, e);
            EasimartKeyValueCache.clearFromKeyValueCache(key);
            return null;
        }
    }
}

