/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartSetOperation;
import co.easimart.Numbers;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartIncrementOperation
implements EasimartFieldOperation {
    private final Number amount;

    public EasimartIncrementOperation(Number amount) {
        this.amount = amount;
    }

    public JSONObject encode(EasimartEncoder objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"Increment");
        output.put("amount", (Object)this.amount);
        return output;
    }

    @Override
    public EasimartFieldOperation mergeWithPrevious(EasimartFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof EasimartDeleteOperation) {
            return new EasimartSetOperation(this.amount);
        }
        if (previous instanceof EasimartSetOperation) {
            Object oldValue = ((EasimartSetOperation)previous).getValue();
            if (oldValue instanceof Number) {
                return new EasimartSetOperation(Numbers.add((Number)oldValue, this.amount));
            }
            throw new IllegalArgumentException("You cannot increment a non-number.");
        }
        if (previous instanceof EasimartIncrementOperation) {
            Number oldAmount = ((EasimartIncrementOperation)previous).amount;
            return new EasimartIncrementOperation(Numbers.add(oldAmount, this.amount));
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        if (oldValue == null) {
            return this.amount;
        }
        if (oldValue instanceof Number) {
            return Numbers.add((Number)oldValue, this.amount);
        }
        throw new IllegalArgumentException("You cannot increment a non-number.");
    }
}

