/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartLog;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

class EasimartImpreciseDateFormat {
    private static final String TAG = "EasimartDateFormat";
    private static final EasimartImpreciseDateFormat INSTANCE = new EasimartImpreciseDateFormat();
    private final Object lock = new Object();
    private final DateFormat dateFormat;

    public static EasimartImpreciseDateFormat getInstance() {
        return INSTANCE;
    }

    private EasimartImpreciseDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.dateFormat = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date parse(String dateString) {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                EasimartLog.e(TAG, "could not parse date: " + dateString, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String format(Date date) {
        Object object = this.lock;
        synchronized (object) {
            return this.dateFormat.format(date);
        }
    }
}

