/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.location.Criteria;
import android.location.Location;
import bolts.Continuation;
import bolts.Task;
import co.easimart.Easimart;
import co.easimart.EasimartTaskUtils;
import co.easimart.LocationCallback;
import co.easimart.LocationNotifier;
import java.util.Locale;

public class EasimartGeoPoint {
    static double EARTH_MEAN_RADIUS_KM = 6371.0;
    static double EARTH_MEAN_RADIUS_MILE = 3958.8;
    private double latitude = 0.0;
    private double longitude = 0.0;

    public EasimartGeoPoint() {
    }

    public EasimartGeoPoint(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public void setLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Latitude must be within the range (-90.0, 90.0).");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be within the range (-180.0, 180.0).");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double distanceInRadiansTo(EasimartGeoPoint point) {
        double d2r = Math.PI / 180;
        double lat1rad = this.latitude * d2r;
        double long1rad = this.longitude * d2r;
        double lat2rad = point.getLatitude() * d2r;
        double long2rad = point.getLongitude() * d2r;
        double deltaLat = lat1rad - lat2rad;
        double deltaLong = long1rad - long2rad;
        double sinDeltaLatDiv2 = Math.sin(deltaLat / 2.0);
        double sinDeltaLongDiv2 = Math.sin(deltaLong / 2.0);
        double a = sinDeltaLatDiv2 * sinDeltaLatDiv2 + Math.cos(lat1rad) * Math.cos(lat2rad) * sinDeltaLongDiv2 * sinDeltaLongDiv2;
        a = Math.min(1.0, a);
        return 2.0 * Math.asin(Math.sqrt(a));
    }

    public double distanceInKilometersTo(EasimartGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_KM;
    }

    public double distanceInMilesTo(EasimartGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_MILE;
    }

    public static Task<EasimartGeoPoint> getCurrentLocationInBackground(long timeout) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(0);
        criteria.setPowerRequirement(0);
        return LocationNotifier.getCurrentLocationAsync(Easimart.getApplicationContext(), timeout, criteria).onSuccess((Continuation)new Continuation<Location, EasimartGeoPoint>(){

            public EasimartGeoPoint then(Task<Location> task) throws Exception {
                Location location = (Location)task.getResult();
                return new EasimartGeoPoint(location.getLatitude(), location.getLongitude());
            }
        });
    }

    public static void getCurrentLocationInBackground(long timeout, LocationCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartGeoPoint.getCurrentLocationInBackground(timeout), callback);
    }

    public static Task<EasimartGeoPoint> getCurrentLocationInBackground(long timeout, Criteria criteria) {
        return LocationNotifier.getCurrentLocationAsync(Easimart.getApplicationContext(), timeout, criteria).onSuccess((Continuation)new Continuation<Location, EasimartGeoPoint>(){

            public EasimartGeoPoint then(Task<Location> task) throws Exception {
                Location location = (Location)task.getResult();
                return new EasimartGeoPoint(location.getLatitude(), location.getLongitude());
            }
        });
    }

    public static void getCurrentLocationInBackground(long timeout, Criteria criteria, LocationCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartGeoPoint.getCurrentLocationInBackground(timeout, criteria), callback);
    }

    public String toString() {
        return String.format(Locale.US, "EasimartGeoPoint[%.6f,%.6f]", this.latitude, this.longitude);
    }
}

