/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartAddOperation;
import co.easimart.EasimartAddUniqueOperation;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartIncrementOperation;
import co.easimart.EasimartRelationOperation;
import co.easimart.EasimartRemoveOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class EasimartFieldOperations {
    private static Map<String, EasimartFieldOperationFactory> opDecoderMap = new HashMap<String, EasimartFieldOperationFactory>();

    private EasimartFieldOperations() {
    }

    private static void registerDecoder(String opName, EasimartFieldOperationFactory factory) {
        opDecoderMap.put(opName, factory);
    }

    static void registerDefaultDecoders() {
        EasimartFieldOperations.registerDecoder("Batch", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                EasimartFieldOperation op = null;
                JSONArray ops = object.getJSONArray("ops");
                for (int i = 0; i < ops.length(); ++i) {
                    EasimartFieldOperation nextOp = EasimartFieldOperations.decode(ops.getJSONObject(i), decoder);
                    op = nextOp.mergeWithPrevious(op);
                }
                return op;
            }
        });
        EasimartFieldOperations.registerDecoder("Delete", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                return EasimartDeleteOperation.getInstance();
            }
        });
        EasimartFieldOperations.registerDecoder("Increment", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                return new EasimartIncrementOperation((Number)decoder.decode(object.opt("amount")));
            }
        });
        EasimartFieldOperations.registerDecoder("Add", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                return new EasimartAddOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        EasimartFieldOperations.registerDecoder("AddUnique", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                return new EasimartAddUniqueOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        EasimartFieldOperations.registerDecoder("Remove", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                return new EasimartRemoveOperation((Collection)decoder.decode(object.opt("objects")));
            }
        });
        EasimartFieldOperations.registerDecoder("AddRelation", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                JSONArray objectsArray = object.optJSONArray("objects");
                List objectsList = (List)decoder.decode(objectsArray);
                return new EasimartRelationOperation(new HashSet(objectsList), null);
            }
        });
        EasimartFieldOperations.registerDecoder("RemoveRelation", new EasimartFieldOperationFactory(){

            @Override
            public EasimartFieldOperation decode(JSONObject object, EasimartDecoder decoder) throws JSONException {
                JSONArray objectsArray = object.optJSONArray("objects");
                List objectsList = (List)decoder.decode(objectsArray);
                return new EasimartRelationOperation(null, new HashSet(objectsList));
            }
        });
    }

    static EasimartFieldOperation decode(JSONObject encoded, EasimartDecoder decoder) throws JSONException {
        String op = encoded.optString("__op");
        EasimartFieldOperationFactory factory = opDecoderMap.get(op);
        if (factory == null) {
            throw new RuntimeException("Unable to decode operation of type " + op);
        }
        return factory.decode(encoded, decoder);
    }

    static ArrayList<Object> jsonArrayAsArrayList(JSONArray array) {
        ArrayList<Object> result = new ArrayList<Object>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                result.add(array.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static interface EasimartFieldOperationFactory {
        public EasimartFieldOperation decode(JSONObject var1, EasimartDecoder var2) throws JSONException;
    }
}

