/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.EasimartConfig;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartFileUtils;
import co.easimart.NoObjectsEncoder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartCurrentConfigController {
    private final Object currentConfigMutex = new Object();
    EasimartConfig currentConfig;
    private File currentConfigFile;

    public EasimartCurrentConfigController(File currentConfigFile) {
        this.currentConfigFile = currentConfigFile;
    }

    public Task<Void> setCurrentConfigAsync(final EasimartConfig config) {
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Object object = EasimartCurrentConfigController.this.currentConfigMutex;
                synchronized (object) {
                    EasimartCurrentConfigController.this.currentConfig = config;
                    EasimartCurrentConfigController.this.saveToDisk(config);
                }
                return null;
            }
        }, (Executor)EasimartExecutors.io());
    }

    public Task<EasimartConfig> getCurrentConfigAsync() {
        return Task.call((Callable)new Callable<EasimartConfig>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EasimartConfig call() throws Exception {
                Object object = EasimartCurrentConfigController.this.currentConfigMutex;
                synchronized (object) {
                    if (EasimartCurrentConfigController.this.currentConfig == null) {
                        EasimartConfig config = EasimartCurrentConfigController.this.getFromDisk();
                        EasimartCurrentConfigController.this.currentConfig = config != null ? config : new EasimartConfig();
                    }
                }
                return EasimartCurrentConfigController.this.currentConfig;
            }
        }, (Executor)EasimartExecutors.io());
    }

    EasimartConfig getFromDisk() {
        JSONObject json;
        try {
            json = EasimartFileUtils.readFileToJSONObject(this.currentConfigFile);
        }
        catch (IOException | JSONException e) {
            return null;
        }
        return new EasimartConfig(json, EasimartDecoder.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCurrentConfigForTesting() {
        Object object = this.currentConfigMutex;
        synchronized (object) {
            this.currentConfig = null;
        }
    }

    void saveToDisk(EasimartConfig config) {
        JSONObject object = new JSONObject();
        try {
            JSONObject jsonParams = (JSONObject)NoObjectsEncoder.get().encode(config.getParams());
            object.put("params", (Object)jsonParams);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize config to JSON");
        }
        try {
            EasimartFileUtils.writeJSONObjectToFile(this.currentConfigFile, object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

