/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.AbstractQueryController;
import co.easimart.CacheQueryController;
import co.easimart.CachedCurrentInstallationController;
import co.easimart.CachedCurrentUserController;
import co.easimart.Easimart;
import co.easimart.EasimartAnalyticsController;
import co.easimart.EasimartAuthenticationManager;
import co.easimart.EasimartCloudCodeController;
import co.easimart.EasimartConfigController;
import co.easimart.EasimartCurrentConfigController;
import co.easimart.EasimartCurrentInstallationController;
import co.easimart.EasimartCurrentUserController;
import co.easimart.EasimartDefaultACLController;
import co.easimart.EasimartFileController;
import co.easimart.EasimartInstallation;
import co.easimart.EasimartObjectController;
import co.easimart.EasimartObjectCurrentCoder;
import co.easimart.EasimartObjectStore;
import co.easimart.EasimartPlugins;
import co.easimart.EasimartPushChannelsController;
import co.easimart.EasimartPushController;
import co.easimart.EasimartQueryController;
import co.easimart.EasimartSessionController;
import co.easimart.EasimartUser;
import co.easimart.EasimartUserController;
import co.easimart.EasimartUserCurrentCoder;
import co.easimart.FileObjectStore;
import co.easimart.LocalIdManager;
import co.easimart.NetworkObjectController;
import co.easimart.NetworkQueryController;
import co.easimart.NetworkSessionController;
import co.easimart.NetworkUserController;
import co.easimart.OfflineObjectStore;
import co.easimart.OfflineQueryController;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

class EasimartCorePlugins {
    private static final EasimartCorePlugins INSTANCE = new EasimartCorePlugins();
    static final String FILENAME_CURRENT_USER = "currentUser";
    static final String PIN_CURRENT_USER = "_currentUser";
    static final String FILENAME_CURRENT_INSTALLATION = "currentInstallation";
    static final String PIN_CURRENT_INSTALLATION = "_currentInstallation";
    static final String FILENAME_CURRENT_CONFIG = "currentConfig";
    private AtomicReference<EasimartObjectController> objectController = new AtomicReference();
    private AtomicReference<EasimartUserController> userController = new AtomicReference();
    private AtomicReference<EasimartSessionController> sessionController = new AtomicReference();
    private AtomicReference<EasimartCurrentUserController> currentUserController = new AtomicReference();
    private AtomicReference<EasimartCurrentInstallationController> currentInstallationController = new AtomicReference();
    private AtomicReference<EasimartAuthenticationManager> authenticationController = new AtomicReference();
    private AtomicReference<EasimartQueryController> queryController = new AtomicReference();
    private AtomicReference<EasimartFileController> fileController = new AtomicReference();
    private AtomicReference<EasimartAnalyticsController> analyticsController = new AtomicReference();
    private AtomicReference<EasimartCloudCodeController> cloudCodeController = new AtomicReference();
    private AtomicReference<EasimartConfigController> configController = new AtomicReference();
    private AtomicReference<EasimartPushController> pushController = new AtomicReference();
    private AtomicReference<EasimartPushChannelsController> pushChannelsController = new AtomicReference();
    private AtomicReference<EasimartDefaultACLController> defaultACLController = new AtomicReference();
    private AtomicReference<LocalIdManager> localIdManager = new AtomicReference();

    public static EasimartCorePlugins getInstance() {
        return INSTANCE;
    }

    private EasimartCorePlugins() {
    }

    void reset() {
        this.objectController.set(null);
        this.userController.set(null);
        this.sessionController.set(null);
        this.currentUserController.set(null);
        this.currentInstallationController.set(null);
        this.authenticationController.set(null);
        this.queryController.set(null);
        this.fileController.set(null);
        this.analyticsController.set(null);
        this.cloudCodeController.set(null);
        this.configController.set(null);
        this.pushController.set(null);
        this.pushChannelsController.set(null);
        this.defaultACLController.set(null);
        this.localIdManager.set(null);
    }

    public EasimartObjectController getObjectController() {
        if (this.objectController.get() == null) {
            this.objectController.compareAndSet(null, new NetworkObjectController(EasimartPlugins.get().restClient()));
        }
        return this.objectController.get();
    }

    public void registerObjectController(EasimartObjectController controller) {
        if (!this.objectController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another object controller was already registered: " + this.objectController.get());
        }
    }

    public EasimartUserController getUserController() {
        if (this.userController.get() == null) {
            this.userController.compareAndSet(null, new NetworkUserController(EasimartPlugins.get().restClient()));
        }
        return this.userController.get();
    }

    public void registerUserController(EasimartUserController controller) {
        if (!this.userController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another user controller was already registered: " + this.userController.get());
        }
    }

    public EasimartSessionController getSessionController() {
        if (this.sessionController.get() == null) {
            this.sessionController.compareAndSet(null, new NetworkSessionController(EasimartPlugins.get().restClient()));
        }
        return this.sessionController.get();
    }

    public void registerSessionController(EasimartSessionController controller) {
        if (!this.sessionController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another session controller was already registered: " + this.sessionController.get());
        }
    }

    public EasimartCurrentUserController getCurrentUserController() {
        if (this.currentUserController.get() == null) {
            File file = new File(Easimart.getEasimartDir(), FILENAME_CURRENT_USER);
            FileObjectStore<EasimartUser> fileStore = new FileObjectStore<EasimartUser>(EasimartUser.class, file, (EasimartObjectCurrentCoder)EasimartUserCurrentCoder.get());
            EasimartObjectStore<EasimartUser> store = Easimart.isLocalDatastoreEnabled() ? new OfflineObjectStore<EasimartUser>(EasimartUser.class, PIN_CURRENT_USER, fileStore) : fileStore;
            CachedCurrentUserController controller = new CachedCurrentUserController(store);
            this.currentUserController.compareAndSet(null, controller);
        }
        return this.currentUserController.get();
    }

    public void registerCurrentUserController(EasimartCurrentUserController controller) {
        if (!this.currentUserController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another currentUser controller was already registered: " + this.currentUserController.get());
        }
    }

    public EasimartQueryController getQueryController() {
        if (this.queryController.get() == null) {
            NetworkQueryController networkController = new NetworkQueryController(EasimartPlugins.get().restClient());
            AbstractQueryController controller = Easimart.isLocalDatastoreEnabled() ? new OfflineQueryController(Easimart.getLocalDatastore(), networkController) : new CacheQueryController(networkController);
            this.queryController.compareAndSet(null, controller);
        }
        return this.queryController.get();
    }

    public void registerQueryController(EasimartQueryController controller) {
        if (!this.queryController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another query controller was already registered: " + this.queryController.get());
        }
    }

    public EasimartFileController getFileController() {
        if (this.fileController.get() == null) {
            this.fileController.compareAndSet(null, new EasimartFileController(EasimartPlugins.get().restClient(), Easimart.getEasimartCacheDir("files")));
        }
        return this.fileController.get();
    }

    public void registerFileController(EasimartFileController controller) {
        if (!this.fileController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another file controller was already registered: " + this.fileController.get());
        }
    }

    public EasimartAnalyticsController getAnalyticsController() {
        if (this.analyticsController.get() == null) {
            this.analyticsController.compareAndSet(null, new EasimartAnalyticsController(Easimart.getEventuallyQueue()));
        }
        return this.analyticsController.get();
    }

    public void registerAnalyticsController(EasimartAnalyticsController controller) {
        if (!this.analyticsController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another analytics controller was already registered: " + this.analyticsController.get());
        }
    }

    public EasimartCloudCodeController getCloudCodeController() {
        if (this.cloudCodeController.get() == null) {
            this.cloudCodeController.compareAndSet(null, new EasimartCloudCodeController(EasimartPlugins.get().restClient()));
        }
        return this.cloudCodeController.get();
    }

    public void registerCloudCodeController(EasimartCloudCodeController controller) {
        if (!this.cloudCodeController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another cloud code controller was already registered: " + this.cloudCodeController.get());
        }
    }

    public EasimartConfigController getConfigController() {
        if (this.configController.get() == null) {
            File file = new File(EasimartPlugins.get().getEasimartDir(), FILENAME_CURRENT_CONFIG);
            EasimartCurrentConfigController currentConfigController = new EasimartCurrentConfigController(file);
            this.configController.compareAndSet(null, new EasimartConfigController(EasimartPlugins.get().restClient(), currentConfigController));
        }
        return this.configController.get();
    }

    public void registerConfigController(EasimartConfigController controller) {
        if (!this.configController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another config controller was already registered: " + this.configController.get());
        }
    }

    public EasimartPushController getPushController() {
        if (this.pushController.get() == null) {
            this.pushController.compareAndSet(null, new EasimartPushController(EasimartPlugins.get().restClient()));
        }
        return this.pushController.get();
    }

    public void registerPushController(EasimartPushController controller) {
        if (!this.pushController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another push controller was already registered: " + this.pushController.get());
        }
    }

    public EasimartPushChannelsController getPushChannelsController() {
        if (this.pushChannelsController.get() == null) {
            this.pushChannelsController.compareAndSet(null, new EasimartPushChannelsController());
        }
        return this.pushChannelsController.get();
    }

    public void registerPushChannelsController(EasimartPushChannelsController controller) {
        if (!this.pushChannelsController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another pushChannels controller was already registered: " + this.pushChannelsController.get());
        }
    }

    public EasimartCurrentInstallationController getCurrentInstallationController() {
        if (this.currentInstallationController.get() == null) {
            File file = new File(EasimartPlugins.get().getEasimartDir(), FILENAME_CURRENT_INSTALLATION);
            FileObjectStore<EasimartInstallation> fileStore = new FileObjectStore<EasimartInstallation>(EasimartInstallation.class, file, EasimartObjectCurrentCoder.get());
            EasimartObjectStore<EasimartInstallation> store = Easimart.isLocalDatastoreEnabled() ? new OfflineObjectStore<EasimartInstallation>(EasimartInstallation.class, PIN_CURRENT_INSTALLATION, fileStore) : fileStore;
            CachedCurrentInstallationController controller = new CachedCurrentInstallationController(store, EasimartPlugins.get().installationId());
            this.currentInstallationController.compareAndSet(null, controller);
        }
        return this.currentInstallationController.get();
    }

    public void registerCurrentInstallationController(EasimartCurrentInstallationController controller) {
        if (!this.currentInstallationController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another currentInstallation controller was already registered: " + this.currentInstallationController.get());
        }
    }

    public EasimartAuthenticationManager getAuthenticationManager() {
        if (this.authenticationController.get() == null) {
            EasimartAuthenticationManager controller = new EasimartAuthenticationManager(this.getCurrentUserController());
            this.authenticationController.compareAndSet(null, controller);
        }
        return this.authenticationController.get();
    }

    public void registerAuthenticationManager(EasimartAuthenticationManager manager) {
        if (!this.authenticationController.compareAndSet(null, manager)) {
            throw new IllegalStateException("Another authentication manager was already registered: " + this.authenticationController.get());
        }
    }

    public EasimartDefaultACLController getDefaultACLController() {
        if (this.defaultACLController.get() == null) {
            EasimartDefaultACLController controller = new EasimartDefaultACLController();
            this.defaultACLController.compareAndSet(null, controller);
        }
        return this.defaultACLController.get();
    }

    public void registerDefaultACLController(EasimartDefaultACLController controller) {
        if (!this.defaultACLController.compareAndSet(null, controller)) {
            throw new IllegalStateException("Another defaultACL controller was already registered: " + this.defaultACLController.get());
        }
    }

    public LocalIdManager getLocalIdManager() {
        if (this.localIdManager.get() == null) {
            LocalIdManager manager = new LocalIdManager(Easimart.getEasimartDir());
            this.localIdManager.compareAndSet(null, manager);
        }
        return this.localIdManager.get();
    }

    public void registerLocalIdManager(LocalIdManager manager) {
        if (!this.localIdManager.compareAndSet(null, manager)) {
            throw new IllegalStateException("Another localId manager was already registered: " + this.localIdManager.get());
        }
    }
}

