/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCommandCache;
import co.easimart.EasimartConfig;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartDecompressInterceptor;
import co.easimart.EasimartEventuallyQueue;
import co.easimart.EasimartFieldOperations;
import co.easimart.EasimartFileUtils;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartKeyValueCache;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartPinningEventuallyQueue;
import co.easimart.EasimartPlugins;
import co.easimart.EasimartUser;
import co.easimart.GcmRegistrar;
import co.easimart.ManifestInfo;
import co.easimart.OfflineStore;
import co.easimart.PushService;
import co.easimart.PushType;
import co.easimart.http.EasimartNetworkInterceptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public class Easimart {
    private static final String EASIMART_APPLICATION_ID = "co.easimart.APPLICATION_ID";
    private static final String EASIMART_CLIENT_KEY = "co.easimart.CLIENT_KEY";
    private static final Object MUTEX = new Object();
    static EasimartEventuallyQueue eventuallyQueue = null;
    private static boolean isLocalDatastoreEnabled;
    private static OfflineStore offlineStore;
    private static final Object MUTEX_CALLBACKS;
    private static Set<EasimartCallbacks> callbacks;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARNING = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_NONE = Integer.MAX_VALUE;
    private static List<EasimartNetworkInterceptor> interceptors;

    public static void enableLocalDatastore(Context context) {
        if (Easimart.isInitialized()) {
            throw new IllegalStateException("`Easimart#enableLocalDatastore(Context)` must be invoked before `Easimart#initialize(Context)`");
        }
        isLocalDatastoreEnabled = true;
    }

    static void disableLocalDatastore() {
        Easimart.setLocalDatastore(null);
        EasimartCorePlugins.getInstance().reset();
    }

    static OfflineStore getLocalDatastore() {
        return offlineStore;
    }

    static void setLocalDatastore(OfflineStore offlineStore) {
        isLocalDatastoreEnabled = offlineStore != null;
        Easimart.offlineStore = offlineStore;
    }

    static boolean isLocalDatastoreEnabled() {
        return isLocalDatastoreEnabled;
    }

    public static void initialize(Context context) {
        String clientKey;
        String applicationId;
        Context applicationContext = context.getApplicationContext();
        Bundle metaData = ManifestInfo.getApplicationMetadata(applicationContext);
        if (metaData != null) {
            applicationId = metaData.getString(EASIMART_APPLICATION_ID);
            clientKey = metaData.getString(EASIMART_CLIENT_KEY);
            if (applicationId == null) {
                throw new RuntimeException("ApplicationId not defined. You must provide ApplicationId in AndroidManifest.xml.\n<meta-data\n    android:name=\"co.easimart.APPLICATION_ID\"\n    android:value=\"<Your Application Id>\" />");
            }
            if (clientKey == null) {
                throw new RuntimeException("ClientKey not defined. You must provide ClientKey in AndroidManifest.xml.\n<meta-data\n    android:name=\"co.easimart.CLIENT_KEY\"\n    android:value=\"<Your Client Key>\" />");
            }
        } else {
            throw new RuntimeException("Can't get Application Metadata");
        }
        Easimart.initialize(context, applicationId, clientKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Context context, String applicationId, String clientKey) {
        EasimartPlugins.Android.initialize(context, applicationId, clientKey);
        Context applicationContext = context.getApplicationContext();
        EasimartHttpClient.setKeepAlive(true);
        EasimartHttpClient.setMaxConnections(20);
        if (interceptors != null) {
            Easimart.initializeEasimartHttpClientsWithEasimartNetworkInterceptors();
        }
        EasimartObject.registerEasimartSubclasses();
        if (Easimart.isLocalDatastoreEnabled()) {
            offlineStore = new OfflineStore(context);
        } else {
            EasimartKeyValueCache.initialize(context);
        }
        Easimart.checkCacheApplicationId();
        new Thread("Easimart.initialize Disk Check & Starting Command Cache"){

            @Override
            public void run() {
                Easimart.getEventuallyQueue();
            }
        }.start();
        EasimartFieldOperations.registerDefaultDecoders();
        if (!Easimart.allEasimartPushIntentReceiversInternal()) {
            throw new SecurityException("To prevent external tampering to your app's notifications, all receivers registered to handle the following actions must have their exported attributes set to false: co.easimart.push.intent.RECEIVE, co.easimart.push.intent.OPEN, co.easimart.push.intent.DELETE");
        }
        GcmRegistrar.getInstance().registerAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartUser.getCurrentUserAsync().makeVoid();
            }
        }).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                EasimartConfig.getCurrentConfig();
                return null;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
        if (ManifestInfo.getPushType() == PushType.PPNS) {
            PushService.startServiceIfRequired(applicationContext);
        }
        Easimart.dispatchOnEasimartInitialized();
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            callbacks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy() {
        EasimartEventuallyQueue queue;
        Object object = MUTEX;
        synchronized (object) {
            queue = eventuallyQueue;
            eventuallyQueue = null;
        }
        if (queue != null) {
            queue.onDestroy();
        }
        EasimartCorePlugins.getInstance().reset();
        EasimartPlugins.reset();
    }

    static boolean isInitialized() {
        return EasimartPlugins.get() != null;
    }

    static Context getApplicationContext() {
        Easimart.checkContext();
        return EasimartPlugins.Android.get().applicationContext();
    }

    private static boolean allEasimartPushIntentReceiversInternal() {
        List<ResolveInfo> intentReceivers = ManifestInfo.getIntentReceivers("co.easimart.push.intent.RECEIVE", "co.easimart.push.intent.DELETE", "co.easimart.push.intent.OPEN");
        for (ResolveInfo resolveInfo : intentReceivers) {
            if (!resolveInfo.activityInfo.exported) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    static File getEasimartDir() {
        return EasimartPlugins.get().getEasimartDir();
    }

    static File getEasimartCacheDir() {
        return EasimartPlugins.get().getCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getEasimartCacheDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Easimart.getEasimartCacheDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    static File getEasimartFilesDir() {
        return EasimartPlugins.get().getFilesDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getEasimartFilesDir(String subDir) {
        Object object = MUTEX;
        synchronized (object) {
            File dir = new File(Easimart.getEasimartFilesDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCacheApplicationId() {
        Object object = MUTEX;
        synchronized (object) {
            String applicationId = EasimartPlugins.get().applicationId();
            if (applicationId != null) {
                File dir = Easimart.getEasimartCacheDir();
                File applicationIdFile = new File(dir, "applicationId");
                if (applicationIdFile.exists()) {
                    boolean matches = false;
                    try {
                        RandomAccessFile f = new RandomAccessFile(applicationIdFile, "r");
                        byte[] bytes = new byte[(int)f.length()];
                        f.readFully(bytes);
                        f.close();
                        String diskApplicationId = new String(bytes, "UTF-8");
                        matches = diskApplicationId.equals(applicationId);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!matches) {
                        try {
                            EasimartFileUtils.deleteDirectory(dir);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                applicationIdFile = new File(dir, "applicationId");
                try {
                    FileOutputStream out = new FileOutputStream(applicationIdFile);
                    out.write(applicationId.getBytes("UTF-8"));
                    out.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EasimartEventuallyQueue getEventuallyQueue() {
        Context context = EasimartPlugins.Android.get().applicationContext();
        Object object = MUTEX;
        synchronized (object) {
            boolean isLocalDatastoreEnabled = Easimart.isLocalDatastoreEnabled();
            if (eventuallyQueue == null || isLocalDatastoreEnabled && eventuallyQueue instanceof EasimartCommandCache || !isLocalDatastoreEnabled && eventuallyQueue instanceof EasimartPinningEventuallyQueue) {
                Easimart.checkContext();
                EasimartHttpClient httpClient = EasimartPlugins.get().restClient();
                EasimartEventuallyQueue easimartEventuallyQueue = eventuallyQueue = isLocalDatastoreEnabled ? new EasimartPinningEventuallyQueue(context, httpClient) : new EasimartCommandCache(context, httpClient);
                if (isLocalDatastoreEnabled && EasimartCommandCache.getPendingCount() > 0) {
                    new EasimartCommandCache(context, httpClient);
                }
            }
            return eventuallyQueue;
        }
    }

    static void checkInit() {
        if (EasimartPlugins.get() == null) {
            throw new RuntimeException("You must call Easimart.initialize(Context) before using the Easimart library.");
        }
        if (EasimartPlugins.get().applicationId() == null) {
            throw new RuntimeException("applicationId is null. You must call Easimart.initialize(Context) before using the Easimart library.");
        }
        if (EasimartPlugins.get().clientKey() == null) {
            throw new RuntimeException("clientKey is null. You must call Easimart.initialize(Context) before using the Easimart library.");
        }
    }

    static void checkContext() {
        if (EasimartPlugins.Android.get().applicationContext() == null) {
            throw new RuntimeException("applicationContext is null. You must call Easimart.initialize(Context) before using the Easimart library.");
        }
    }

    static boolean hasPermission(String permission2) {
        return Easimart.getApplicationContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    static void requirePermission(String permission2) {
        if (!Easimart.hasPermission(permission2)) {
            throw new IllegalStateException("To use this functionality, add this to your AndroidManifest.xml:\n<uses-permission android:name=\"" + permission2 + "\" />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerEasimartCallbacks(EasimartCallbacks listener) {
        if (Easimart.isInitialized()) {
            throw new IllegalStateException("You must register callbacks before Easimart.initialize(Context)");
        }
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterEasimartCallbacks(EasimartCallbacks listener) {
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (callbacks == null) {
                return;
            }
            callbacks.remove(listener);
        }
    }

    private static void dispatchOnEasimartInitialized() {
        EasimartCallbacks[] callbacks = Easimart.collectEasimartCallbacks();
        if (callbacks != null) {
            for (EasimartCallbacks callback : callbacks) {
                callback.onEasimartInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EasimartCallbacks[] collectEasimartCallbacks() {
        EasimartCallbacks[] callbacks;
        Object object = MUTEX_CALLBACKS;
        synchronized (object) {
            if (Easimart.callbacks == null) {
                return null;
            }
            callbacks = new EasimartCallbacks[Easimart.callbacks.size()];
            if (Easimart.callbacks.size() > 0) {
                callbacks = Easimart.callbacks.toArray(callbacks);
            }
        }
        return callbacks;
    }

    public static void setLogLevel(int logLevel) {
        EasimartLog.setLogLevel(logLevel);
    }

    public static int getLogLevel() {
        return EasimartLog.getLogLevel();
    }

    private Easimart() {
        throw new AssertionError();
    }

    private static void initializeEasimartHttpClientsWithEasimartNetworkInterceptors() {
        if (interceptors == null) {
            return;
        }
        ArrayList<EasimartHttpClient> clients = new ArrayList<EasimartHttpClient>();
        clients.add(EasimartPlugins.get().restClient());
        clients.add(EasimartCorePlugins.getInstance().getFileController().awsClient());
        for (EasimartHttpClient easimartHttpClient : clients) {
            easimartHttpClient.addInternalInterceptor(new EasimartDecompressInterceptor());
            for (EasimartNetworkInterceptor interceptor : interceptors) {
                easimartHttpClient.addExternalInterceptor(interceptor);
            }
        }
        interceptors = null;
    }

    public static void addEasimartNetworkInterceptor(EasimartNetworkInterceptor interceptor) {
        if (Easimart.isInitialized()) {
            throw new IllegalStateException("`Easimart#addEasimartNetworkInterceptor(EasimartNetworkInterceptor)` must be invoked before `Easimart#initialize(Context)`");
        }
        if (interceptors == null) {
            interceptors = new ArrayList<EasimartNetworkInterceptor>();
        }
        interceptors.add(interceptor);
    }

    public static void removeEasimartNetworkInterceptor(EasimartNetworkInterceptor interceptor) {
        if (Easimart.isInitialized()) {
            throw new IllegalStateException("`Easimart#addEasimartNetworkInterceptor(EasimartNetworkInterceptor)` must be invoked before `Easimart#initialize(Context)`");
        }
        if (interceptors == null) {
            return;
        }
        interceptors.remove(interceptor);
    }

    static String externalVersionName() {
        return "a1.11.1-SNAPSHOT";
    }

    static {
        MUTEX_CALLBACKS = new Object();
        callbacks = new HashSet<EasimartCallbacks>();
    }

    static interface EasimartCallbacks {
        public void onEasimartInitialized();
    }
}

