/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.app.runtime.spark.python;

import co.cask.cdap.common.lang.jar.BundleJarUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipOutputStream;

public final class PySparkUtil {
    public static File createPySparkLib(File tempDir) throws IOException, URISyntaxException {
        URL initPyURL = PySparkUtil.class.getClassLoader().getResource("cdap/pyspark/__init__.py");
        if (initPyURL == null) {
            throw new IOException("Missing CDAP cdap/pyspark/__init__.py from classloader");
        }
        if ("jar".equals(initPyURL.getProtocol())) {
            return new File(URI.create(initPyURL.getPath().substring(0, initPyURL.getPath().indexOf("!/"))));
        }
        File libFile = new File(tempDir, "cdap-pyspark-lib.zip");
        try (ZipOutputStream output = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(libFile)));){
            File basePathDir = new File(initPyURL.toURI()).getParentFile().getParentFile();
            BundleJarUtil.addToArchive((File)basePathDir, (boolean)true, (ZipOutputStream)output);
        }
        return libFile;
    }
}

