/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.spark.sql;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.JavaConversions;
import scala.runtime.AbstractFunction1;

public final class DataFrames {
    private static final Function1<Schema, DataType> DEFAULT_UNION_SELECTOR = new AbstractFunction1<Schema, DataType>(){

        public DataType apply(Schema schema) {
            if (schema.isNullable()) {
                return DataFrames.schemaToDataType(schema.getNonNullable(), (Function1<Schema, DataType>)((Function1)this));
            }
            throw new IllegalArgumentException("Union schema is not support: " + schema);
        }
    };

    public static <T extends DataType> T toDataType(Schema schema) {
        return DataFrames.toDataType(schema, DEFAULT_UNION_SELECTOR);
    }

    public static <T extends DataType> T toDataType(Schema schema, Function1<Schema, DataType> unionSelector) {
        return (T)DataFrames.schemaToDataType(schema, unionSelector);
    }

    public static Schema toSchema(DataType dataType) {
        return DataFrames.dataTypeToSchema(dataType, new int[]{0});
    }

    public static Row toRow(StructuredRecord record, StructType structType) {
        return (Row)DataFrames.toRowValue(record, (DataType)structType, "");
    }

    public static StructuredRecord fromRow(Row row, Schema schema) {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("Only record type schema is supported");
        }
        return (StructuredRecord)DataFrames.fromRowValue(row, schema, "");
    }

    private static DataType schemaToDataType(Schema schema, Function1<Schema, DataType> unionSelector) {
        switch (schema.getType()) {
            case NULL: {
                return DataTypes.NullType;
            }
            case BOOLEAN: {
                return DataTypes.BooleanType;
            }
            case INT: {
                return DataTypes.IntegerType;
            }
            case LONG: {
                return DataTypes.LongType;
            }
            case FLOAT: {
                return DataTypes.FloatType;
            }
            case DOUBLE: {
                return DataTypes.DoubleType;
            }
            case BYTES: {
                return DataTypes.BinaryType;
            }
            case STRING: {
                return DataTypes.StringType;
            }
            case ENUM: {
                return DataTypes.StringType;
            }
            case ARRAY: {
                Schema componentSchema = schema.getComponentSchema();
                return DataTypes.createArrayType((DataType)DataFrames.schemaToDataType(componentSchema, unionSelector), (boolean)componentSchema.isNullable());
            }
            case MAP: {
                Map.Entry mapSchema = schema.getMapSchema();
                return DataTypes.createMapType((DataType)DataFrames.schemaToDataType((Schema)mapSchema.getKey(), unionSelector), (DataType)DataFrames.schemaToDataType((Schema)mapSchema.getValue(), unionSelector), (boolean)((Schema)mapSchema.getValue()).isNullable());
            }
            case RECORD: {
                ArrayList<StructField> structFields = new ArrayList<StructField>(schema.getFields().size());
                for (Schema.Field field : schema.getFields()) {
                    Schema fieldSchema = field.getSchema();
                    DataType fieldType = DataFrames.schemaToDataType(fieldSchema, unionSelector);
                    structFields.add(DataTypes.createStructField((String)field.getName(), (DataType)fieldType, (boolean)fieldSchema.isNullable()));
                }
                return DataTypes.createStructType(structFields);
            }
            case UNION: {
                return (DataType)unionSelector.apply((Object)schema);
            }
        }
        throw new IllegalArgumentException("Unsupported schema: " + schema);
    }

    private static Schema dataTypeToSchema(DataType dataType, int[] recordCounter) {
        if (dataType.equals(DataTypes.NullType)) {
            return Schema.of((Schema.Type)Schema.Type.NULL);
        }
        if (dataType.equals(DataTypes.BooleanType)) {
            return Schema.of((Schema.Type)Schema.Type.BOOLEAN);
        }
        if (dataType.equals(DataTypes.ByteType)) {
            return Schema.of((Schema.Type)Schema.Type.INT);
        }
        if (dataType.equals(DataTypes.ShortType)) {
            return Schema.of((Schema.Type)Schema.Type.INT);
        }
        if (dataType.equals(DataTypes.IntegerType)) {
            return Schema.of((Schema.Type)Schema.Type.INT);
        }
        if (dataType.equals(DataTypes.LongType)) {
            return Schema.of((Schema.Type)Schema.Type.LONG);
        }
        if (dataType.equals(DataTypes.FloatType)) {
            return Schema.of((Schema.Type)Schema.Type.FLOAT);
        }
        if (dataType.equals(DataTypes.DoubleType)) {
            return Schema.of((Schema.Type)Schema.Type.DOUBLE);
        }
        if (dataType.equals(DataTypes.BinaryType)) {
            return Schema.of((Schema.Type)Schema.Type.BYTES);
        }
        if (dataType.equals(DataTypes.StringType)) {
            return Schema.of((Schema.Type)Schema.Type.STRING);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            if (arrayType.elementType() == DataTypes.ByteType) {
                return Schema.of((Schema.Type)Schema.Type.BYTES);
            }
            Schema componentSchema = DataFrames.dataTypeToSchema(arrayType.elementType(), recordCounter);
            return Schema.arrayOf((Schema)(arrayType.containsNull() ? Schema.nullableOf((Schema)componentSchema) : componentSchema));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            Schema valueSchema = DataFrames.dataTypeToSchema(mapType.valueType(), recordCounter);
            return Schema.mapOf((Schema)DataFrames.dataTypeToSchema(mapType.keyType(), recordCounter), (Schema)(mapType.valueContainsNull() ? Schema.nullableOf((Schema)valueSchema) : valueSchema));
        }
        if (dataType instanceof StructType) {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (StructField structField : ((StructType)dataType).fields()) {
                Schema fieldSchema = DataFrames.dataTypeToSchema(structField.dataType(), recordCounter);
                fields.add(Schema.Field.of((String)structField.name(), (Schema)(structField.nullable() ? Schema.nullableOf((Schema)fieldSchema) : fieldSchema)));
            }
            int n = recordCounter[0];
            recordCounter[0] = n + 1;
            return Schema.recordOf((String)("Record" + n), fields);
        }
        if (dataType.equals(DataTypes.TimestampType)) {
            return Schema.of((Schema.Type)Schema.Type.LONG);
        }
        if (dataType.equals(DataTypes.DateType)) {
            return Schema.of((Schema.Type)Schema.Type.LONG);
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.typeName());
    }

    private static Object toRowValue(@Nullable Object value, DataType dataType, String path) {
        if (value == null) {
            return null;
        }
        if (dataType.equals(DataTypes.NullType)) {
            return null;
        }
        if (dataType.equals(DataTypes.BooleanType)) {
            return value;
        }
        if (dataType.equals(DataTypes.ByteType)) {
            return value;
        }
        if (dataType.equals(DataTypes.ShortType)) {
            return value;
        }
        if (dataType.equals(DataTypes.IntegerType)) {
            return value;
        }
        if (dataType.equals(DataTypes.LongType)) {
            return value;
        }
        if (dataType.equals(DataTypes.FloatType)) {
            return value;
        }
        if (dataType.equals(DataTypes.DoubleType)) {
            return value;
        }
        if (dataType.equals(DataTypes.BinaryType)) {
            if (value instanceof ByteBuffer) {
                return Bytes.toBytes((ByteBuffer)((ByteBuffer)value));
            }
            return value;
        }
        if (dataType.equals(DataTypes.StringType)) {
            return value;
        }
        if (dataType instanceof ArrayType) {
            List<Object> collection;
            if (value instanceof Collection) {
                collection = (List<Object>)value;
            } else if (value.getClass().isArray()) {
                collection = Arrays.asList((Object[])value);
            } else {
                throw new IllegalArgumentException("Value type " + value.getClass() + " is not supported as array type value. It must either be a Collection or an array");
            }
            ArrayList<Object> result = new ArrayList<Object>(collection.size());
            String elementPath = path + "[]";
            ArrayType arrayType = (ArrayType)dataType;
            for (Object e : collection) {
                Object elementValue = DataFrames.toRowValue(e, arrayType.elementType(), elementPath);
                if (elementValue == null && !arrayType.containsNull()) {
                    throw new IllegalArgumentException("Null value is not allowed for array element at " + elementPath);
                }
                result.add(elementValue);
            }
            return JavaConversions.asScalaBuffer(result).toSeq();
        }
        if (dataType instanceof MapType) {
            Map map = (Map)value;
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(map.size());
            String mapPath = path + "<>";
            MapType mapType = (MapType)dataType;
            for (Map.Entry entry : map.entrySet()) {
                Object object = DataFrames.toRowValue(entry.getKey(), mapType.keyType(), mapPath);
                if (object == null) {
                    throw new IllegalArgumentException("Null key is not allowed for map at " + mapPath);
                }
                Object mapValue = DataFrames.toRowValue(entry.getValue(), mapType.valueType(), mapPath);
                if (mapValue == null && !mapType.valueContainsNull()) {
                    throw new IllegalArgumentException("Null value is not allowed for map at " + mapPath);
                }
                result.put(object, mapValue);
            }
            return JavaConversions.mapAsScalaMap(result);
        }
        if (dataType instanceof StructType) {
            StructuredRecord record = (StructuredRecord)value;
            StructField[] fields = ((StructType)dataType).fields();
            Object[] fieldValues = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].name();
                String fieldPath = path + "/" + fieldName;
                Object object = DataFrames.toRowValue(record.get(fieldName), fields[i].dataType(), fieldPath);
                if (object == null && !fields[i].nullable()) {
                    throw new IllegalArgumentException("Null value is not allowed for row field at " + fieldPath);
                }
                fieldValues[i] = object;
            }
            return RowFactory.create((Object[])fieldValues);
        }
        if (dataType.equals(DataTypes.TimestampType)) {
            return new Timestamp((Long)value);
        }
        if (dataType.equals(DataTypes.DateType)) {
            return new Date((Long)value);
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType.typeName());
    }

    private static Object fromRowValue(Object value, Schema schema, String path) {
        switch (schema.getType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: {
                return value;
            }
            case BYTES: {
                return ByteBuffer.wrap((byte[])value);
            }
            case ARRAY: {
                Collection collection = (Collection)value;
                ArrayList<Object> result = new ArrayList<Object>(collection.size());
                Schema componentSchema = schema.getComponentSchema();
                Schema valueSchema = DataFrames.getNonNullIfNullable(componentSchema);
                String elementPath = path + "[]";
                for (Object element : collection) {
                    if (element == null && !componentSchema.isNullable()) {
                        throw new IllegalArgumentException("Null value is not allowed for array element at " + elementPath);
                    }
                    result.add(DataFrames.fromRowValue(element, valueSchema, path));
                }
                return result;
            }
            case MAP: {
                Map map = (Map)value;
                LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(map.size());
                Map.Entry mapSchema = schema.getMapSchema();
                Schema keySchema = DataFrames.getNonNullIfNullable((Schema)mapSchema.getKey());
                Schema valueSchema = DataFrames.getNonNullIfNullable((Schema)mapSchema.getValue());
                String mapPath = path + "<>";
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null && !((Schema)mapSchema.getValue()).isNullable()) {
                        throw new IllegalArgumentException("Null value is not allowed for map at " + mapPath);
                    }
                    result.put(DataFrames.fromRowValue(entry.getKey(), keySchema, path), DataFrames.fromRowValue(entry.getValue(), valueSchema, path));
                }
                return result;
            }
            case RECORD: {
                Row row = (Row)value;
                StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
                int idx = 0;
                for (Schema.Field field : schema.getFields()) {
                    String fieldPath = path + "/" + field.getName();
                    Schema fieldSchema = field.getSchema();
                    if (row.isNullAt(idx) && !fieldSchema.isNullable()) {
                        throw new NullPointerException("Null value is not allowed in record field at " + fieldPath);
                    }
                    fieldSchema = DataFrames.getNonNullIfNullable(fieldSchema);
                    if (row.isNullAt(idx)) {
                        ++idx;
                        continue;
                    }
                    if (fieldSchema.getType() == Schema.Type.ARRAY) {
                        builder.set(field.getName(), DataFrames.fromRowValue(row.getList(idx), fieldSchema, fieldPath));
                    } else if (fieldSchema.getType() == Schema.Type.MAP) {
                        builder.set(field.getName(), DataFrames.fromRowValue(row.getJavaMap(idx), fieldSchema, fieldPath));
                    } else {
                        Object fieldValue = row.get(idx);
                        if (fieldValue instanceof Date) {
                            fieldValue = ((Date)fieldValue).getTime();
                        } else if (fieldValue instanceof Timestamp) {
                            fieldValue = ((Timestamp)fieldValue).getTime();
                        }
                        builder.set(field.getName(), DataFrames.fromRowValue(fieldValue, fieldSchema, fieldPath));
                    }
                    ++idx;
                }
                return builder.build();
            }
        }
        throw new IllegalArgumentException("Unsupported schema: " + schema);
    }

    private static Schema getNonNullIfNullable(Schema schema) {
        return schema.isNullable() ? schema.getNonNullable() : schema;
    }

    private DataFrames() {
    }
}

