/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.examples.fileset;

import co.cask.cdap.api.Resources;
import co.cask.cdap.api.data.batch.Input;
import co.cask.cdap.api.data.batch.Output;
import co.cask.cdap.api.mapreduce.AbstractMapReduce;
import co.cask.cdap.api.mapreduce.MapReduceContext;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class WordCount
extends AbstractMapReduce {
    public void configure() {
        this.setMapperResources(new Resources(1024));
        this.setReducerResources(new Resources(1024));
    }

    public void beforeSubmit(MapReduceContext context) throws Exception {
        Job job = (Job)context.getHadoopJob();
        job.setMapperClass(Tokenizer.class);
        job.setReducerClass(Counter.class);
        job.setNumReduceTasks(1);
        String inputDataset = (String)context.getRuntimeArguments().get("input");
        inputDataset = inputDataset != null ? inputDataset : "lines";
        String outputDataset = (String)context.getRuntimeArguments().get("output");
        outputDataset = outputDataset != null ? outputDataset : "counts";
        context.addInput(Input.ofDataset((String)inputDataset));
        context.addOutput(Output.ofDataset((String)outputDataset));
    }

    public static class Counter
    extends Reducer<Text, IntWritable, String, Long> {
        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long sum = 0L;
            for (IntWritable value : values) {
                sum += (long)value.get();
            }
            context.write((Object)key.toString(), (Object)sum);
        }
    }

    public static class Tokenizer
    extends Mapper<LongWritable, Text, Text, IntWritable> {
        private Text word = new Text();
        private static final IntWritable ONE = new IntWritable(1);

        public void map(LongWritable key, Text data, Mapper.Context context) throws IOException, InterruptedException {
            for (String token : data.toString().split(" ")) {
                this.word.set(token);
                context.write((Object)this.word, (Object)ONE);
            }
        }
    }
}

