/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.examples.fileset;

import co.cask.cdap.api.Transactional;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.dataset.DatasetManagementException;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.InstanceConflictException;
import co.cask.cdap.api.dataset.InstanceNotFoundException;
import co.cask.cdap.api.dataset.lib.FileSet;
import co.cask.cdap.api.service.AbstractService;
import co.cask.cdap.api.service.http.AbstractHttpServiceHandler;
import co.cask.cdap.api.service.http.HttpContentConsumer;
import co.cask.cdap.api.service.http.HttpServiceHandler;
import co.cask.cdap.api.service.http.HttpServiceRequest;
import co.cask.cdap.api.service.http.HttpServiceResponder;
import com.google.common.io.Closeables;
import com.google.gson.Gson;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.twill.filesystem.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSetService
extends AbstractService {
    protected void configure() {
        this.setName("FileSetService");
        this.setDescription("A Service to uploads files to, or downloads files from, the \"lines\" and \"counts\" file sets.");
        this.setInstances(1);
        this.addHandler((HttpServiceHandler)new FileSetHandler());
    }

    public static class FileSetHandler
    extends AbstractHttpServiceHandler {
        private static final Gson GSON = new Gson();
        private static final Logger LOG = LoggerFactory.getLogger(FileSetHandler.class);

        @GET
        @Path(value="{fileset}")
        public void read(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set, @QueryParam(value="path") String filePath) {
            FileSet fileSet;
            try {
                fileSet = (FileSet)this.getContext().getDataset(set);
            }
            catch (DatasetInstantiationException e) {
                LOG.warn("Error instantiating file set {}", (Object)set, (Object)e);
                responder.sendError(400, String.format("Invalid file set name '%s'", set));
                return;
            }
            Location location = fileSet.getLocation(filePath);
            this.getContext().discardDataset((Dataset)fileSet);
            try {
                responder.send(200, location, "application/octet-stream");
            }
            catch (IOException e) {
                responder.sendError(400, String.format("Unable to read path '%s' in file set '%s'", filePath, set));
            }
        }

        @PUT
        @Path(value="{fileset}")
        public HttpContentConsumer write(HttpServiceRequest request, HttpServiceResponder responder, final @PathParam(value="fileset") String set, final @QueryParam(value="path") String filePath) {
            FileSet fileSet;
            try {
                fileSet = (FileSet)this.getContext().getDataset(set);
            }
            catch (DatasetInstantiationException e) {
                LOG.warn("Error instantiating file set {}", (Object)set, (Object)e);
                responder.sendError(400, String.format("Invalid file set name '%s'", set));
                return null;
            }
            final Location location = fileSet.getLocation(filePath);
            this.getContext().discardDataset((Dataset)fileSet);
            try {
                final WritableByteChannel channel = Channels.newChannel(location.getOutputStream());
                return new HttpContentConsumer(){

                    public void onReceived(ByteBuffer chunk, Transactional transactional) throws Exception {
                        channel.write(chunk);
                    }

                    public void onFinish(HttpServiceResponder responder) throws Exception {
                        channel.close();
                        responder.sendStatus(200);
                    }

                    public void onError(HttpServiceResponder responder, Throwable failureCause) {
                        Closeables.closeQuietly((Closeable)channel);
                        try {
                            location.delete();
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to delete {}", (Object)location, (Object)e);
                        }
                        LOG.debug("Unable to write path '{}' in file set '{}'", new Object[]{filePath, set, failureCause});
                        responder.sendError(400, String.format("Unable to write path '%s' in file set '%s'. Reason: '%s'", filePath, set, failureCause.getMessage()));
                    }
                };
            }
            catch (IOException e) {
                responder.sendError(400, String.format("Unable to write path '%s' in file set '%s'. Reason: '%s'", filePath, set, e.getMessage()));
                return null;
            }
        }

        @POST
        @Path(value="{fileset}/create")
        public void create(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set, @Nullable @QueryParam(value="clone") String clone) throws DatasetManagementException {
            DatasetProperties properties = DatasetProperties.EMPTY;
            ByteBuffer content = request.getContent();
            if (clone != null) {
                try {
                    properties = this.getContext().getAdmin().getDatasetProperties(clone);
                }
                catch (InstanceNotFoundException e) {
                    responder.sendError(404, "Dataset '" + clone + "' does not exist");
                    return;
                }
            }
            if (content != null && content.hasRemaining()) {
                try {
                    properties = (DatasetProperties)GSON.fromJson(Bytes.toString((ByteBuffer)content), DatasetProperties.class);
                }
                catch (Exception e) {
                    responder.sendError(400, "Invalid properties: " + e.getMessage());
                    return;
                }
            }
            try {
                this.getContext().getAdmin().createDataset(set, "fileSet", properties);
            }
            catch (InstanceConflictException e) {
                responder.sendError(409, "Dataset '" + set + "' already exists");
                return;
            }
            responder.sendStatus(200);
        }

        @POST
        @Path(value="{fileset}/update")
        public void update(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set) throws DatasetManagementException {
            DatasetProperties properties = DatasetProperties.EMPTY;
            ByteBuffer content = request.getContent();
            if (content != null && content.hasRemaining()) {
                try {
                    properties = (DatasetProperties)GSON.fromJson(Bytes.toString((ByteBuffer)content), DatasetProperties.class);
                }
                catch (Exception e) {
                    responder.sendError(400, "Invalid properties: " + e.getMessage());
                    return;
                }
            }
            try {
                this.getContext().getAdmin().updateDataset(set, properties);
            }
            catch (InstanceNotFoundException e) {
                responder.sendError(404, "Dataset '" + set + "' does not exist");
                return;
            }
            responder.sendStatus(200);
        }

        @POST
        @Path(value="{fileset}/drop")
        public void drop(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set) throws DatasetManagementException {
            try {
                this.getContext().getAdmin().dropDataset(set);
            }
            catch (InstanceNotFoundException e) {
                responder.sendError(404, "Dataset '" + set + "' does not exist");
                return;
            }
            responder.sendStatus(200);
        }

        @POST
        @Path(value="{fileset}/truncate")
        public void truncate(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set) throws DatasetManagementException {
            try {
                this.getContext().getAdmin().truncateDataset(set);
            }
            catch (InstanceNotFoundException e) {
                responder.sendError(404, "Dataset '" + set + "' does not exist");
                return;
            }
            responder.sendStatus(200);
        }

        @POST
        @Path(value="{fileset}/properties")
        public void properties(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileset") String set) throws DatasetManagementException {
            try {
                DatasetProperties props = this.getContext().getAdmin().getDatasetProperties(set);
                responder.sendJson(200, (Object)props);
            }
            catch (InstanceNotFoundException e) {
                responder.sendError(404, "Dataset '" + set + "' does not exist");
            }
        }
    }
}

