/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.examples.fileset;

import co.cask.cdap.api.annotation.UseDataSet;
import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.dataset.lib.FileSet;
import co.cask.cdap.api.service.AbstractService;
import co.cask.cdap.api.service.http.AbstractHttpServiceHandler;
import co.cask.cdap.api.service.http.HttpServiceHandler;
import co.cask.cdap.api.service.http.HttpServiceRequest;
import co.cask.cdap.api.service.http.HttpServiceResponder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.twill.filesystem.Location;

public class FileSetService
extends AbstractService {
    protected void configure() {
        this.setName("FileSetService");
        this.setDescription("A Service to uploads files to, or downloads files from, the \"lines\" and \"counts\" file sets.");
        this.setInstances(1);
        this.addHandler((HttpServiceHandler)new FileSetHandler());
    }

    public static class FileSetHandler
    extends AbstractHttpServiceHandler {
        @UseDataSet(value="lines")
        private FileSet lines;
        @UseDataSet(value="counts")
        private FileSet counts;

        @GET
        @Path(value="{fileSet}")
        public void read(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileSet") String set, @QueryParam(value="path") String filePath) {
            ByteBuffer content;
            FileSet fileSet;
            try {
                fileSet = (FileSet)this.getContext().getDataset(set);
            }
            catch (DatasetInstantiationException e) {
                responder.sendError(400, String.format("Invalid file set name '%s'", set));
                return;
            }
            Location location = fileSet.getLocation(filePath);
            try {
                content = ByteBuffer.wrap(ByteStreams.toByteArray((InputStream)location.getInputStream()));
            }
            catch (IOException e) {
                responder.sendError(400, String.format("Unable to read path '%s' in file set '%s'", filePath, set));
                return;
            }
            responder.send(200, content, "application/octet-stream", (Multimap)ImmutableMultimap.of());
        }

        @PUT
        @Path(value="{fileSet}")
        public void write(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="fileSet") String set, @QueryParam(value="path") String filePath) {
            FileSet fileSet;
            try {
                fileSet = (FileSet)this.getContext().getDataset(set);
            }
            catch (DatasetInstantiationException e) {
                responder.sendError(400, String.format("Invalid file set name '%s'", set));
                return;
            }
            Location location = fileSet.getLocation(filePath);
            try (WritableByteChannel channel = Channels.newChannel(location.getOutputStream());){
                channel.write(request.getContent());
            }
            catch (IOException e) {
                responder.sendError(400, String.format("Unable to write path '%s' in file set '%s'", filePath, set));
                return;
            }
            responder.sendStatus(200);
        }
    }
}

