/*
 * Decompiled with CFR 0.152.
 */
package cn.shorturl.store.template;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DefaultRedisTemplate<K, V>
extends RedisTemplate<K, V> {
    public DefaultRedisTemplate(Class<K> kClass, Class<V> vClass) {
        if (kClass.equals(String.class)) {
            this.setKeySerializer(RedisSerializer.string());
            this.setHashKeySerializer(RedisSerializer.string());
        } else {
            this.setKeySerializer((RedisSerializer)new Jackson2JsonRedisSerializer(kClass));
            this.setHashKeySerializer((RedisSerializer)new Jackson2JsonRedisSerializer(kClass));
        }
        this.setValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(vClass));
        this.setHashValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(vClass));
    }

    public DefaultRedisTemplate(Class<K> kClass, Class<V> vClass, RedisConnectionFactory connectionFactory) {
        this(kClass, vClass);
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }
}

