/*
 * Decompiled with CFR 0.152.
 */
package cn.shorturl.store.store;

import cn.shorturl.core.ShortUrl;
import cn.shorturl.core.ShortUrlUtil;
import cn.shorturl.store.ShortUrlStore;
import cn.shorturl.store.exception.HashAlreadyException;
import cn.shorturl.store.template.ShortUrlRedisTemplate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class RedisShortUrlStore
extends ShortUrlStore {
    ShortUrlRedisTemplate redisTemplate;
    public static final String SHORT_KEY = "short:url:";

    public RedisShortUrlStore(ShortUrlUtil util, ShortUrlRedisTemplate redisTemplate) {
        this.util = util;
        this.redisTemplate = redisTemplate;
    }

    @Override
    protected ShortUrl add(ShortUrl shortUrl) {
        Boolean save;
        System.out.println(shortUrl);
        String key = SHORT_KEY + shortUrl.getHash();
        Date expire = shortUrl.getGmtExpire();
        if (expire != null) {
            long time = expire.getTime() - System.currentTimeMillis();
            if (time < 0L) {
                return null;
            }
            save = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)shortUrl, time, TimeUnit.MILLISECONDS);
        } else {
            save = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)shortUrl);
        }
        if (!Boolean.TRUE.equals(save)) {
            throw new HashAlreadyException("hash already exists");
        }
        return shortUrl;
    }

    @Override
    public ShortUrl get(String hash) {
        return (ShortUrl)this.redisTemplate.opsForValue().get((Object)(SHORT_KEY + hash));
    }

    @Override
    public boolean contains(String hash) {
        return this.redisTemplate.opsForValue().get((Object)(SHORT_KEY + hash)) != null;
    }
}

