/*
 * Decompiled with CFR 0.152.
 */
package cn.shorturl.store;

import cn.shorturl.core.ShortUrl;
import cn.shorturl.core.ShortUrlUtil;
import java.util.Date;

public abstract class ShortUrlStore {
    protected ShortUrlUtil util;

    public ShortUrl add(String url) {
        return this.add(url, null);
    }

    public ShortUrl add(String url, Date expireTime) {
        Integer max = this.util.getConfig().getRetryMax();
        if (max == null || max < 1) {
            max = 10;
        }
        ShortUrl shortUrl = new ShortUrl().setUrl(url).setGmtExpire(expireTime).setGmtCreate(new Date());
        for (int i = 0; i < max; ++i) {
            String hash = this.hash(url);
            if (this.contains(hash)) {
                url = url + (int)(Math.random() * 10.0);
                continue;
            }
            try {
                shortUrl.setHash(hash);
                this.add(shortUrl);
                return shortUrl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("add short url failed");
    }

    protected abstract ShortUrl add(ShortUrl var1);

    public abstract ShortUrl get(String var1);

    public abstract boolean contains(String var1);

    public String hash(String url) {
        return this.util.gen(url);
    }
}

