package cn.zzq0324.radish.web.log;

import java.util.Date;
import java.util.Map;
import lombok.Data;

/**
 * 访问日志记录
 *
 * @author zzq0324
 * @since : 1.0.0
 */
@Data
public class AccessLog {

  /**
   * 请求时间
   */
  private Date createTime;

  /**
   * 耗时，单位：毫秒
   */
  private Long elapsed;

  /**
   * UA信息
   */
  private String userAgent;

  /**
   * 调用端IP
   */
  private String clientIp;

  /**
   * 请求地址，未经过任何处理
   */
  private String requestUri;

  /**
   * 匹配的url，例如请求地址为: GET /users/1，那么requestUri为/users/1，urlPattern为/users/{id}
   */
  private String urlPattern;

  /**
   * 处理器，格式为类名-方法名，方便定位问题
   */
  private String handler;

  /**
   * HTTP方法
   */
  private String httpMethod;

  /**
   * HTTP状态码
   */
  private Integer httpStatusCode;

  /**
   * 请求数据
   */
  private String requestData;

  /**
   * 异常信息
   */
  private Throwable exception;

  // 上下文信息，用于存放要记录的扩展字段
  private Map<String, String> context;
}
