package cn.zzq0324.radish.web.i18n;

import cn.zzq0324.radish.common.dto.response.Response;
import java.lang.reflect.Method;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 国际化advice，需要在异常拦截之后，确保异常的也能国际化处理
 *
 * @author  zzq0324
 * @since : 1.0.0
 */
@Slf4j
@Order(20)
@ConditionalOnProperty(value = "spring.messages.basename")
@ConditionalOnBean(MessageSource.class)
@RestControllerAdvice
public class InternationalResponseAdvice implements ResponseBodyAdvice<Response> {

  private static final String I18N_STATUS_CODE = "code.%d";

  @Autowired(required = false)
  @Qualifier(AbstractApplicationContext.MESSAGE_SOURCE_BEAN_NAME)
  private MessageSource messageSource;

  @Override
  public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
    Method method = methodParameter.getMethod();
    if (method == null) {
      return false;
    }

    return Response.class.getName().equalsIgnoreCase(method.getReturnType().getName());
  }

  @Override
  public Response beforeBodyWrite(Response body, MethodParameter returnType, MediaType selectedContentType,
      Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request,
      ServerHttpResponse response) {
    // 未配置i18n信息，直接返回原始信息
    if (messageSource == null) {
      return body;
    }

    // TODO(zzq0324) 国际化包装后返回，解析出错不能影响原有流程

    return body;
  }
}
