package cn.zzq0324.radish.web.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.stereotype.Component;

/**
 * 拦截器注解，注解在实现HandlerInterceptor的类上
 *
 * @author zzq0324
 * @since : 1.0.0
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Component
public @interface Interceptor {

  /**
   * 需要过滤拦截的路径
   */
  String[] excludePaths() default {};

  /**
   * 设置要拦截的路径
   */
  String[] includePaths() default {};
}
