package cn.zzq0324.radish.web.uitl;

import cn.zzq0324.radish.web.annotation.SkipInterceptor;
import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

/**
 * 拦截器工具
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class InterceptorUtils {

  /**
   * 获取拦截器目标方法上的注解
   */
  public static HandlerMethod getHandlerMethod(Object handler) {
    if (!(handler instanceof HandlerMethod)) {
      return null;
    }

    return (HandlerMethod) handler;
  }

  /**
   * 获取拦截器目标方法上的注解
   */
  public static <T extends Annotation> T getAnnotationFromMethod(Object handler, Class<T> type) {
    HandlerMethod handlerMethod = getHandlerMethod(handler);
    if (handlerMethod == null) {
      return null;
    }

    return AnnotationUtils.findAnnotation(handlerMethod.getMethod(), type);
  }

  public static <T extends Annotation> T getAnnotationFromBeanType(Object handler, Class<T> type) {
    HandlerMethod handlerMethod = getHandlerMethod(handler);
    if (handlerMethod == null) {
      return null;
    }

    return AnnotationUtils.findAnnotation(handlerMethod.getBeanType(), type);
  }

  /**
   * 是否标注了跳过拦截器
   */
  public static boolean annotateSkipInterceptor(Object handler) {
    HandlerMethod handlerMethod = getHandlerMethod(handler);
    if (getAnnotationFromMethod(handlerMethod, SkipInterceptor.class) != null) {
      return true;
    }

    if (getAnnotationFromBeanType(handlerMethod, SkipInterceptor.class) != null) {
      return true;
    }

    return false;
  }
}
