package cn.zzq0324.radish.web.log;

import cn.zzq0324.radish.web.constant.RadishWebConstants;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;

/**
 * 访问日志拦截器，可以通过配置控制是否启用，默认启用
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Slf4j
@Component
@ConditionalOnProperty(value = RadishWebConstants.ENABLE_ACCESS_LOG, havingValue = "true", matchIfMissing = true)
public class AccessLogFilter extends OncePerRequestFilter {

  @Override
  protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
      throws ServletException, IOException {
    ContentCachingRequestWrapper requestWrapper = wrapRequest(request);

    AccessLogger accessLogger = new AccessLogger(request);

    try {
      // 由于异常被@ControllerAdvice拦截并处理，导致此处catch exception没效果
      // 因此在WebMvcAccessLogger通过request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE)解决
      filterChain.doFilter(requestWrapper, response);
    } finally {
      accessLogger.log(request, response);
    }
  }

  /**
   * 包装HttpServletRequest解决InputStream无法重复读的问题
   */
  private ContentCachingRequestWrapper wrapRequest(HttpServletRequest request) {
    if (request instanceof ContentCachingRequestWrapper) {
      return (ContentCachingRequestWrapper) request;
    }

    return new ContentCachingRequestWrapper(request);
  }
}
